// User extensions can be added here.
//
// Keep this file to avoid  mystifying "Invalid Character" error in IE

var FCKTestLib =
{
	LoadURLData : null,
	LoadURL : function( url )
	{
		var backReference = this ;
		this.LoadURLData = null ;
		var reqArgs = 
		{
			"method" : "get",
			"onSuccess" : function( response )
			{
				backReference.LoadURLData = response.responseText ;
			}
		};
		new Ajax.Request( url, reqArgs );
	},
	ReduceTree : function( editor, root )
	{
		root.normalize() ;
		var curNode = root ;
		var nodesToDelete = [] ;
		while ( curNode )
		{
			if ( curNode.nodeType == 1 )
			{
				editor.FCKDomTools.TrimNode( curNode ) ;
				if ( editor.FCKListsLib.BlockBoundaries[curNode.nodeName.toLowerCase()]
						&& curNode.lastChild
						&& curNode.lastChild.nodeName.toLowerCase() == 'br' )
					curNode.removeChild( curNode.lastChild ) ;
			}
			else if ( curNode.nodeType == 3 )
			{
				// usual spaces in HTML can always be compressed to a single space and not affect 
				// the visual appearence... except for things inside a <pre>
				if ( curNode.parentNode && curNode.parentNode.nodeName.toLowerCase() != 'pre' )
				{
					curNode.nodeValue = curNode.nodeValue.replace( /[ \t\r\n]+/g, ' ' ) ;
				}

				// spaces just after or just before a block node or <br> are useless
				var prevNode = curNode.previousSibling ;
				var nextNode = curNode.nextSibling ;
				var prevNodeName = prevNode ? prevNode.nodeName.toLowerCase() : "" ;
				var nextNodeName = nextNode ? nextNode.nodeName.toLowerCase() : "" ;
				if ( editor.FCKListsLib.BlockBoundaries[ prevNodeName ] || prevNodeName == 'br' )
					curNode.nodeValue = curNode.nodeValue.replace( /^[ \t\r\n]+/g, '' ) ;
				if ( editor.FCKListsLib.BlockBoundaries[ nextNodeName ] || nextNodeName == 'br' )
					curNode.nodeValue = curNode.nodeValue.replace( /[ \t\r\n]+$/g, '' ) ;
				if ( curNode.nodeValue == '' )
					nodesToDelete.push( curNode ) ;
			}
			curNode = editor.FCKDomTools.GetNextSourceNode( curNode ) ;
		}
		while ( nodesToDelete.length > 0 )
		{
			var n = nodesToDelete.shift() ;
			n.parentNode.removeChild( n ) ;
		}
	}
};

Selenium.prototype.doFckLoadContents = function( url )
{
	var win = this.browserbot.getCurrentWindow() ;
	var doc = win.FCK.EditorDocument ;
	var waitFunc = function()
	{
		if ( FCKTestLib.LoadURLData == null )
			return false ;
		doc.body.innerHTML = FCKTestLib.LoadURLData ;
		var range = new win.FCKDomRange( win.FCK.EditorWindow ) ;
		range.MoveToBookmark( {"StartId" : "SelStart", "EndId" : "SelEnd"} ) ;
		range.Select() ;
		return true ;
	}
	FCKTestLib.LoadURL( url ) ;
	return Selenium.decorateFunctionWithTimeout( waitFunc, 5000 ) ;
}

Selenium.prototype.doFckExecuteCommand = function( command )
{
	var win = this.browserbot.getCurrentWindow() ;
	win.FCK.Commands.GetCommand( command ).Execute() ;
}

// I can't implement the following as an isXyz function in Selenium because it involves Ajax calls and thus timeouts
Selenium.prototype.doFckCheckSimilarTo = function( url )
{
	var win = this.browserbot.getCurrentWindow() ;
	var editorBody = win.FCK.EditorDocument.body.cloneNode( true ) ;
	var verifyBody = document.createElement( 'body' ) ;
	var waitFunc = function()
	{
		if ( FCKTestLib.LoadURLData == null )
			return false ;
		verifyBody.innerHTML = FCKTestLib.LoadURLData ;
		FCKTestLib.ReduceTree( win, editorBody ) ;
		FCKTestLib.ReduceTree( win, verifyBody ) ;
		// remove the padding node, if any
		if ( verifyBody.childNodes.length < editorBody.childNodes.length 
				&& editorBody.lastChild.nodeName.toLowerCase() == win.FCKConfig.EnterMode.toLowerCase()
		  		&& !editorBody.lastChild.firstChild )
			editorBody.removeChild( editorBody.lastChild ) ;
		// check if the two reduced trees are similar
		var editorNode = editorBody ;
		var verifyNode = verifyBody ;
		while ( editorNode || verifyNode )
		{
			if ( ! editorNode )
				throw new SeleniumError( "DOM structure mismatch: missing DOM node in editor document - "
					       + verifyNode.nodeName + " expected." ) ;
			if ( ! verifyNode )
				throw new SeleniumError( "DOM structure mismatch: missing DOM node in verification document - "
					       + editorNode.nodeName + " expected." ) ;
			if ( editorNode.nodeType == 1 && editorNode.nodeName != verifyNode.nodeName )
				throw new SeleniumError( "DOM structure mismatch: element tags are different - "
					       + editorNode.nodeName + " encountered in editor document while "
					       + verifyNode.nodeName + " is expected by verification document." ) ;
			if ( editorNode.nodeType == 3 && editorNode.nodeValue != verifyNode.nodeValue )
				throw new SeleniumError( "DOM structure mismatch: text node values are different - "
						+ "'" + editorNode.nodeValue + "' is different "
						+ " to '" + verifyNode.nodeValue + "'." ) ;
			editorNode = win.FCKDomTools.GetNextSourceNode( editorNode ) ;
			verifyNode = win.FCKDomTools.GetNextSourceNode( verifyNode ) ;
		}
		return true ;
	}
	FCKTestLib.LoadURL( url ) ;
	return Selenium.decorateFunctionWithTimeout( waitFunc, 5000 ) ;
}
