var isIE = ( navigator.userAgent.search( 'MSIE' ) != -1 ) ;
function $(id)
{
	return document.getElementById( id );
}

function addOption( selector, value, desc )
{
	var option = document.createElement( 'option' ) ;
	option.value = value ;
	option.text = desc ;
	if ( isIE )
		selector.add( option ) ;
	else
		selector.add( option, null );
}

function drawSelectPage()
{
	var project = $( 'projectSelector' ).value ;
	var testType = $( 'typeSelector' ).value ;
	var suiteType = $( 'subTypeSelector' ).value  ;
	var suiteSelector = $( 'suiteSelector' ) ;
	var suiteValue = suiteSelector.value ;
	var testFrame = $( 'testFrame' ) ;
	var drawPage = function( evt )
	{
		if ( ! evt )
			evt = window.event ;
		if ( evt.type == 'readystatechange' && this.readyState != 'complete' )
			return ;
		var doc = testFrame.contentWindow.document ;
		var html = "<h1>Select a test...</h1>" ;
		doc.body.innerHTML = html ;
		var handler = function()
		{
			suiteSelector.value = this.value ;
			suiteSelector.onchange() ;
		}
		var options = suiteSelector.options ;
		for ( var i = 1 ; i < options.length ; i++ )
		{
			var anchor = doc.createElement( 'a' ) ;
			anchor.style.textDecoration = 'underline' ;
			anchor.style.color = 'navy' ;
			anchor.style.cursor = 'pointer' ;
			anchor.onclick = handler ;
			anchor.value = options[i].value ;
			anchor.appendChild( doc.createTextNode( options[i].text ) ) ;
			doc.body.appendChild( anchor ) ;
			doc.body.appendChild( doc.createElement( 'br' ) ) ;
		}
		if ( options.length == 1 )
			doc.body.innerHTML += 'There are no tests defined for this test suite.' ;
	}
	testFrame.onload = testFrame.onreadystatechange = drawPage ;
	testFrame.src = "" ;
}

function updateTestFrame()
{
	var project = $( 'projectSelector' ).value ;
	var testType = $( 'typeSelector' ).value ;
	var suiteValue = $( 'suiteSelector' ).value ;
	var testFrame = $( 'testFrame' ) ;
	testFrame.onload = testFrame.onreadystatechange = null ;
	var suiteType = $( 'subTypeSelector' ).value  ;

	if (suiteValue == 'select' )
		return drawSelectPage() ;
	var hrefPrefix = [ FCKTestConfig.BasePath, project, testType == 'design' ? 'ds' : 'ts', suiteType ].join( '/' ) ;
	if ( suiteType == 'interactive' )
		testFrame.src = hrefPrefix + '/' + suiteValue ;
	else if ( suiteType == 'visual' )
	{
		var testSuite = Test[project][testType][suiteType]['suite'][parseInt( suiteValue )] ;
		var callbackTemplate = function( doc )
		{
			var testCaseTable = doc.getElementById( 'testCaseTable' ) ;
			
			var titleRow = doc.createElement( 'tr' ) ;
			var titleCell = doc.createElement( 'td' ) ;
			titleCell.innerHTML = '<b></b>' ;
			titleCell.getElementsByTagName( 'b' )[0].appendChild( doc.createTextNode( testSuite.description ) ) ;
			titleRow.appendChild( titleCell ) ;
			testCaseTable.appendChild( titleRow ) ;

			for ( var i = 0 ; i < testSuite.testcase.length ; i++ )
			{
				var row = doc.createElement( 'tr' ) ;
				var cell = doc.createElement( 'td' ) ;
				cell.innerHTML = '<a></a>' ;
				var anchor = cell.getElementsByTagName( 'a' )[0] ;
				anchor.href = hrefPrefix + '/' + testSuite.testcase[i][0] ;
				anchor.appendChild( doc.createTextNode( testSuite.testcase[i][1] ) ) ;
				row.appendChild(cell) ;
				testCaseTable.appendChild( row ) ;
			}
		}
		window.seleniumGlueCallback = callbackTemplate ;

		testFrame.src = FCKTestConfig.BasePath + '/runners/selenium/TestRunner.html?test=' + 
			[ FCKTestConfig.BasePath, 'runners/selenium_glue.html' ].join( '/' ) ;
	}
	else if ( suiteType == 'unit' )
	{
		var testSuite = Test[project][testType][suiteType][parseInt( suiteValue )] ;
		var callbackTemplate = function( win )
		{
			win.testcase = testSuite;
			win.hrefPrefix = hrefPrefix ;
		}
		window.jsunitGlueCallback = callbackTemplate ;
		var handler = function(evt)
		{
			if ( !evt )
				evt = window.event ;
			if ( evt.type == 'readystatechange' && this.readyState != 'complete' )
				return ;
			var doc = testFrame.contentWindow.document ;
			doc.body.style.textAlign = 'center' ;
			doc.body.innerHTML = 'A popup window with JSUnit should appear. If you can\'t see it, disable popup blocker.' ;
		}
		testFrame.onload = testFrame.onreadystatechange = handler ;
		testFrame.src = "";

		var glue_url = encodeURIComponent( FCKTestConfig.BasePath + '/runners/jsunit_glue.html' ) ;
		var url = FCKTestConfig.BasePath + '/runners/jsunit/testRunner.html?testpage=' + glue_url ;
		window.open( url, '_blank' ) ;
	}
}

function updateSuiteSelector()
{
	var project = $( 'projectSelector' ).value ;
	var type = $( 'typeSelector' ).value ;
	var subtype = $( 'subTypeSelector' ).value ;
	var tests = Test[project][type] ;
	var suiteSelector = $( 'suiteSelector' ) ;
	suiteSelector.innerHTML = '' ;
	var interactiveTests = tests.interactive ;
	var visualTests = tests.visual ;
	var unitTests = tests.unit ;
	addOption( suiteSelector, "select", "(Select Test)" ) ;
	if ( subtype == 'interactive' )
	{
		for ( var i = 0 ; i < interactiveTests.length ; i++ )
			addOption( suiteSelector, interactiveTests[i][0], 
					"Interactive test: " + interactiveTests[i][1] ) ;
	}
	else if ( subtype == 'visual' )
	{
		for ( var i = 0 ; i < visualTests.suite.length ; i++ )
			addOption( suiteSelector, i, "Visual test: " + visualTests.suite[i].description ) ;
	}
	else if ( subtype == 'unit' )
	{
		for ( var i = 0 ; i < unitTests.length ; i++ )
			addOption( suiteSelector, i, "Unit test: " + unitTests[i] ) ;
	}
	updateTestFrame() ;
}

function init()
{
	var projectSelector = $( 'projectSelector' );
	var typeSelector = $( 'typeSelector' ) ;
	var subTypeSelector = $( 'subTypeSelector' ) ;
	var suiteSelector = $( 'suiteSelector' ) ;
	for ( var i in Test )
		addOption( projectSelector, i, Test[i]['description'] ) ;
	projectSelector.value = projectSelector.getElementsByTagName( 'option' )[0].value ;
	updateSuiteSelector() ;
	projectSelector.onchange = updateSuiteSelector ;
	typeSelector.onchange = updateSuiteSelector ;
	subTypeSelector.onchange = updateSuiteSelector ;
	suiteSelector.onchange = updateTestFrame ;
}

