/*
 * FCKeditor - The text editor for Internet - http://www.fckeditor.net
 * Copyright (C) 2003-2007 Frederico Caldeira Knabben
 * 
 * == BEGIN LICENSE ==
 * 
 * Licensed under the terms of any of the following licenses at your
 * choice:
 * 
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 * 
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 * 
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 * 
 * == END LICENSE ==
 */

package com.fredck.fckeditor;

import java.io.BufferedInputStream;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;

/**
 * Holds the global properties. Defaults are read from a property file. With a
 * setter methode you can overwrite defaults or set new one.
 * 
 * @version $Id: DefaultPropertiesHolder.java 1312 2008-01-14 22:41:41Z mosipov $
 */
public class DefaultPropertiesHolder {
    private static Map properties = new Hashtable();
    
    static {
	try {
	    Properties props = new Properties();
		props.load(new BufferedInputStream(DefaultPropertiesHolder.class
		        .getResourceAsStream("default.properties")));
	    properties = props;
	} catch (Exception e) {
		// TODO log4j
	    throw new RuntimeException("Can't read default.properties!");
	}
    }
    
    public static String get(final String key) {
	return (String)properties.get(key);
    }
    
    public static Map getAll() {
	return properties;
    }

}
