/*
 * FCKeditor - The text editor for Internet - http://www.fckeditor.net
 * Copyright (C) 2003-2007 Frederico Caldeira Knabben
 * 
 * == BEGIN LICENSE ==
 * 
 * Licensed under the terms of any of the following licenses at your
 * choice:
 * 
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 * 
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 * 
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 * 
 * == END LICENSE ==
 */

package com.fredck.fckeditor;

import javax.servlet.http.HttpServletRequest;

import com.fredck.fckeditor.tool.Compatibility;

/**
 * FCKeditor control class.<br>
 * It's the container for all properties and the class that generate the output based on browser capabilities and
 * configurations passed by the developer.
 * 
 * @version $Id: FCKeditor.java 1312 2008-01-14 22:41:41Z mosipov $
 */
public class FCKeditor {

    private FCKeditorConfigurations oConfig;
    private String instanceName;
    private String value;
    private String basePath;
    private String toolbarSet;
    private String width;
    private String height;

    private HttpServletRequest request;

    /**
     * Initialize the object setting all basic configurations.<br>
     * 
     * The basePath is context root + {@link ConfigurationHandler#getFckEditorDir()}.
     * 
     * @param request
     *                request object
     * @param instanceName
     *                unique name
     * @param width
     *                width
     * @param height
     *                height
     * @param toolbarSet
     *                toolbarSet name
     * @param value
     *                initial value
     */
    public FCKeditor(final HttpServletRequest request, final String instanceName, final String width,
	    final String height, final String toolbarSet, final String value) {
	this.request = request;
	// TODO muss das mit einem Slash abgeschlossen werden?
	this.basePath = request.getContextPath() + ConfigurationHandler.getFckEditorDir() + "/";
	this.instanceName = instanceName;

	// set defaults, if required
	this.value = (value == null) ? "" : value;
	this.toolbarSet = (toolbarSet == null) ? ConfigurationHandler.getFckEditorToolbarSet() : toolbarSet;
	this.width = (width == null) ? ConfigurationHandler.getFckEditorWidth() : width;
	this.height = (height == null) ? ConfigurationHandler.getFckEditorHeight() : height;

	oConfig = new FCKeditorConfigurations();
    }

    /**
     * Just a wrapper to {@link FCKeditor}.
     * 
     * @param req
     *                request object
     */
    // TODO Konstruktor würde ich auf deprecated setzten
    /*
     * Grund: Laut Server Side Integeratin sollte auf jeden Fall instanceName übergeben
     */
    public FCKeditor(HttpServletRequest req) {
	this(req, null, null, null, null, null);
    }

    /**
     * Just a wrapper to {@link FCKeditor}.
     * 
     * @param req
     *                request object
     * @param parInstanceName
     *                unique name
     */
    public FCKeditor(HttpServletRequest req, String parInstanceName) {
	this(req, parInstanceName, null, null, null, null);
    }

    /**
     * Get the unique name of the editor
     * 
     * @return name
     */
    public String getInstanceName() {
	return instanceName;
    }

    /**
     * Set the unique name of the editor
     * 
     * @param value
     *                name
     */
    public void setInstanceName(String value) {
	instanceName = value;
    }

    /**
     * Get the initial value to be edited.<br>
     * In HTML code
     * 
     * @return value
     */
    public String getValue() {
	return value;
    }

    /**
     * Set the initial value to be edited.<br>
     * In HTML code
     * 
     * @param value
     *                value
     */
    public void setValue(String value) {
	this.value = value;
    }

    /**
     * Get the dir where the FCKeditor files reside on the server
     * 
     * @return path
     */
    public String getBasePath() {
	return basePath;
    }

    /**
     * Set the dir where the FCKeditor files reside on the server.<br>
     * <b>Remarks</b>:<br>
     * Avoid using relative paths. It is preferable to set the base path starting from the root (/).<br>
     * Always finish the path with a slash (/).
     * 
     * @param value
     *                path
     */
    public void setBasePath(String value) {
	basePath = value;
    }

    /**
     * Get the name of the toolbar to display
     * 
     * @return toolbar name
     */
    public String getToolbarSet() {
	return toolbarSet;
    }

    /**
     * Set the name of the toolbar to display
     * 
     * @param value
     *                toolbar name
     */
    public void setToolbarSet(String value) {
	toolbarSet = value;
    }

    /**
     * Get the width of the textarea
     * 
     * @return width
     */
    public String getWidth() {
	return width;
    }

    /**
     * Set the width of the textarea
     * 
     * @param value
     *                width
     */
    public void setWidth(String value) {
	width = value;
    }

    /**
     * Get the height of the textarea
     * 
     * @return height
     */
    public String getHeight() {
	return height;
    }

    /**
     * Set the height of the textarea
     * 
     * @param value
     *                height
     */
    public void setHeight(String value) {
	height = value;
    }

    /**
     * Get the advanced configuation set.<br>
     * Adding element to this collection you can override the settings specified in the config.js file.
     * 
     * @return configuration collection
     */
    public FCKeditorConfigurations getConfig() {
	return oConfig;
    }

    /**
     * Set the advanced configuation set.
     * 
     * @param value
     *                configuration collection
     */
    public void setConfig(FCKeditorConfigurations value) {
	oConfig = value;
    }

    // TODO Methoden fangen mit Kleinbuchstaben an
    private String HTMLEncode(String txt) {
	txt = txt.replaceAll("&", "&amp;");
	txt = txt.replaceAll("<", "&lt;");
	txt = txt.replaceAll(">", "&gt;");
	txt = txt.replaceAll("\"", "&quot;");
	txt = txt.replaceAll("'", "&#146;");
	return txt;
    }

    /**
     * Generate the HTML Code for the editor. <br>
     * Evalute the browser capabilities and generate the editor if compatible, or a simple textarea otherwise.
     * 
     * @return html code
     */
    public String create() {
    	// TODO Eventuell StringBuilder, da der schneller ist
    	// Wie sind dann aber in Multiuser env
    	StringBuffer strEditor = new StringBuffer();

	strEditor.append("<div>");
	String encodedValue = HTMLEncode(value);

	if (Compatibility.check(request.getHeader("user-agent"))) {

		 // TODO Variablen separat hinzufügen
		strEditor.append("<input type=\"hidden\" id=\"" + instanceName + "\" name=\"" + instanceName
		    + "\" value=\"" + encodedValue + "\">");

	    strEditor.append(createConfigHTML());
	    strEditor.append(createIFrameHTML());

	} else {
	    // TODO s.o.
		// TODO lowercase HTML tags nutzen
		strEditor.append("<TEXTAREA name=\"" + instanceName + "\" rows=\"4\" cols=\"40\" style=\"WIDTH: " + width
		    + "; HEIGHT: " + height + "\" wrap=\"virtual\">" + encodedValue + "</TEXTAREA>");
	}
	strEditor.append("</div>");
	return strEditor.toString();
    }

    private String createConfigHTML() {
	String configStr = oConfig.getUrlParams();
	if (!configStr.equals(""))
	    configStr = configStr.substring(1);

	return "<input type=\"hidden\" id=\"" + instanceName + "___Config\" value=\"" + configStr + "\">";
    }

    private String createIFrameHTML() {
	// TODO eventuell mit neuer Pfadstruktur untersuchen
    	String sLink = basePath + "editor/fckeditor.html?InstanceName=" + instanceName;

	if (!toolbarSet.equals(""))
	    sLink += "&Toolbar=" + toolbarSet;

	 // TODO Variablen separat hinzufügen
	return "<iframe id=\"" + instanceName + "___Frame\" src=\"" + sLink + "\" width=\"" + width + "\" height=\""
		+ height + "\" frameborder=\"no\" scrolling=\"no\"></iframe>";
    }
    
    /**
     * Checks the compatibility of the browser of the current request.
     * 
     * @return True, if compatible or false.
     * @see {@link Compatibility#check(String)}
     */
    public boolean isCompatibleBrowser() {
	if (request != null)
	    return Compatibility.check(request.getHeader("user-agent"));
	return false;
    }
}
