/*
 * FCKeditor - The text editor for Internet - http://www.fckeditor.net
 * Copyright (C) 2003-2007 Frederico Caldeira Knabben
 * 
 * == BEGIN LICENSE ==
 * 
 * Licensed under the terms of any of the following licenses at your
 * choice:
 * 
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 * 
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 * 
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 * 
 * == END LICENSE ==
 */
package net.fckeditor.tool;

import java.util.HashMap;
import java.util.Map;

/**
 * Tool to construct a XHTML-tag.
 *
 * @version $Id: XHtmlTagTool.java 1351 2008-01-17 17:42:05Z th-schwarz $
 */
public class XHtmlTagTool {
    
    /** name of the tag */
    private String name;
       
    /** container for the attributes */
    private Map<String, String> attributes = new HashMap<String, String>();
        
    /** value of the tag. if value='' tag will be close simalary value is set */
    private String value = null;
    
    
    
    public XHtmlTagTool(final String name) {
	this(name, null);
    }
    
    public XHtmlTagTool(final String name, final String value) {
	if (Utils.isEmpty(name))
	    throw new IllegalArgumentException("Parameter 'name' shouldn't be null!");
	this.name = name;
	this.value = value;
    }
    
    
    
    public void setValue(final String value) {
	this.value = value;
    }
    
    public void addAttribute(final String key, final String value) {
	attributes.put(key, value);
    }


    /**
     * Constructs the tag.
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
	StringBuilder tag = new StringBuilder();
	
	// open tag
	tag.append("<").append(name);
	
	// add attributes
	for (String key : attributes.keySet()) {
	    String val = attributes.get(key);
	    tag.append(' ').append(key).append('=').append('\"').append(val).append('\"');
	}
	
	// close the tag
	if (value != null) {
	    tag.append(">").append(value).append("</").append(name).append('>');
	} else
	    tag.append("/>");
	
	return tag.toString();
    }
}
