package net.fckeditor.tags;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;

import net.fckeditor.handlers.ConfigurationHandler;
import net.fckeditor.tool.Compatibility;

public class CheckTag extends TagSupport {

	private static final long serialVersionUID = -6834095891675681686L;

	private static final String FILE_UPLOAD = "FileUpload";
	private static final String FILE_BROWSING = "FileBrowsing";
	private static final String COMPATIBLE_BROWSER = "CompatibleBrowser";
	private static Set<String> commands = new HashSet<String>(3);

	static {
		commands.add(FILE_UPLOAD);
		commands.add(FILE_BROWSING);
		commands.add(COMPATIBLE_BROWSER);
	}

	private String command;

	public void setCommand(String command) throws JspTagException {
		if (!commands.contains(command))
			throw new JspTagException(
					"You have to provide one of the following commands: "
							+ commands);
		this.command = command;
	}

	@Override
	public int doStartTag() throws JspException {
		JspWriter out = pageContext.getOut();

		HttpServletRequest request = (HttpServletRequest) pageContext
				.getRequest();
		String response = new String();

		if (command.equals(FILE_UPLOAD)) {
			if (ConfigurationHandler.isEnabledForFileUpload(request))
				response = ConfigurationHandler
						.getDefaultProperty(ConfigurationHandler.PROPERTY_MESSAGE_FILE_UPLOAD_ENABLED);
			else
				response = ConfigurationHandler
						.getDefaultProperty(ConfigurationHandler.PROPERTY_MESSAGE_FILE_UPLOAD_DISABLED);
		}

		if (command.equals(FILE_BROWSING)) {
			if (ConfigurationHandler.isEnabledForFileBrowsing(request))
				response = ConfigurationHandler
						.getDefaultProperty(ConfigurationHandler.PROPERTY_MESSAGE_FILE_BROWSING_ENABLED);
			else
				response = ConfigurationHandler
						.getDefaultProperty(ConfigurationHandler.PROPERTY_MESSAGE_FILE_BROWSING_DISABLED);
		}
		if (command.equals(COMPATIBLE_BROWSER)) {
			if (Compatibility.isCompatibleBrowser(request))
				response = ConfigurationHandler
						.getDefaultProperty(ConfigurationHandler.PROPERTY_MESSAGE_COMPATIBLE_BROWSER);
			else
				response = ConfigurationHandler
						.getDefaultProperty(ConfigurationHandler.PROPERTY_MESSAGE_NOT_COMPATIBLE_BROWSER);
		}

		try {
			out.print(response);
		} catch (IOException e) {
			e.printStackTrace();
		}

		return SKIP_BODY;
	}

}
