package net.fckeditor;

import java.util.HashMap;
import java.util.Map;

public class ResourceType {

	private String name;
	private static Map<String, ResourceType> types = new HashMap<String, ResourceType>(
			4);
	public static final ResourceType FILE = new ResourceType("File");
	public static final ResourceType IMAGE = new ResourceType("Image");
	public static final ResourceType FLASH = new ResourceType("Flash");
	public static final ResourceType MEDIA = new ResourceType("Media");

	static {
		types.put(FILE.getName(), FILE);
		types.put(IMAGE.getName(), IMAGE);
		types.put(FLASH.getName(), FLASH);
		types.put(MEDIA.getName(), MEDIA);
	}

	public ResourceType(final String name) {
		this.name = name;
	}

	public String getName() {
		return name;
	}

	@Override
	public String toString() {

		return name;
	}

	public String getPath() {
		return "/" + name.toLowerCase();
	}

	public static ResourceType valueOf(final String name)
			throws NullPointerException, IllegalArgumentException {

		if (name == null)
			throw new NullPointerException();

		ResourceType rt = types.get(name);

		if (rt == null)
			throw new IllegalArgumentException();

		return rt;
	}

	public static boolean isValid(final String name) {
		return types.containsKey(name);
	}
	
	public static ResourceType getDefaultResourceType(final String name) {

		ResourceType rt = getResourceType(name);

		return rt == null ? FILE : rt;

	}

	public static ResourceType getResourceType(final String name) {

		try {
			return ResourceType.valueOf(name);
		} catch (IllegalArgumentException e) {
			return null;
		} catch (NullPointerException e) {
			return null;
		}
	}
	
	@Override
	public boolean equals(Object obj) {
		
		try {
			ResourceType rt = (ResourceType) obj;
			return name.equals(rt.getName());
		} catch (ClassCastException e) {
			return false;
		}
	}

}
