/*
 * FCKeditor - The text editor for Internet - http://www.fckeditor.net
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 * 
 * == BEGIN LICENSE ==
 * 
 * Licensed under the terms of any of the following licenses at your
 * choice:
 * 
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 * 
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 * 
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 * 
 * == END LICENSE ==
 */
package net.fckeditor.handlers;

import javax.servlet.http.HttpServletRequest;

import net.fckeditor.SessionData;

/**
 * Handeler for some base properties.
 * 
 * @version $Id: FCKEditorHandler.java 1585 2008-02-21 18:13:09Z th-schwarz $
 */
public class FCKEditorHandler {

	/**
     * Getter for the base dir (using for user files).
     * 
     * @return {@link SessionData#getUserFilesPath(HttpServletRequest)} or the default base dir, if
     *         {@link SessionData}} isn't set.
     */
    public static String getUserFilesPath(final HttpServletRequest servletRequest) {
    	String userFilePath = SessionDataHandler.getUserFilePath(servletRequest);
    	return (userFilePath != null) ? userFilePath : getDefaultUserFilesPath();
    }

	/**
	 * Getter for the default handling of single extensions.
	 * 
	 * @return the forceSingleExtension
	 */
	public static boolean isForceSingleExtension() {
		return Boolean.valueOf(PropertiesLoader.getProperty("connector.forceSingleExtension"));
	}

	/**
	 * Getter for the value to instruct the connector to return the full URL of a file/folder in the
	 * XML response rather than the absolute URL.
	 * 
	 * @return
	 */
	public static boolean isFullUrl() {
		return Boolean.valueOf(PropertiesLoader.getProperty("connector.fullUrl"));
	}

	/**
	 * Getter for the default userFilesPath.
	 * 
	 * @return Default userfiles path (/userfiles)
	 */
	public static String getDefaultUserFilesPath() {
		return PropertiesLoader.getProperty("connector.userFilesPath");
	}
}
