/*
 * FCKeditor - The text editor for Internet - http://www.fckeditor.net
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 * 
 * == BEGIN LICENSE ==
 * 
 * Licensed under the terms of any of the following licenses at your
 * choice:
 * 
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 * 
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 * 
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 * 
 * == END LICENSE ==
 */
package net.fckeditor.handlers;

import java.util.HashMap;
import java.util.Map;

import net.fckeditor.tool.Utils;

/**
 * Handler for the different resource types.
 *
 * @version $Id: ResourceTypeHandler.java 1585 2008-02-21 18:13:09Z th-schwarz $
 */
public class ResourceTypeHandler {

	private String name;
	private static Map<String, ResourceTypeHandler> types = new HashMap<String, ResourceTypeHandler>(
			4);
	public static final ResourceTypeHandler FILE = new ResourceTypeHandler("File");
	public static final ResourceTypeHandler IMAGE = new ResourceTypeHandler("Image");
	public static final ResourceTypeHandler FLASH = new ResourceTypeHandler("Flash");
	public static final ResourceTypeHandler MEDIA = new ResourceTypeHandler("Media");
	

	static {
		types.put(FILE.getName(), FILE);
		types.put(IMAGE.getName(), IMAGE);
		types.put(FLASH.getName(), FLASH);
		types.put(MEDIA.getName(), MEDIA);
	}

	private ResourceTypeHandler(final String name) {
		this.name = name;
	}

	public String getName() {
		return name;
	}

	public String getPath() {
		String propKey = "connector.resourceType.".concat(name.toLowerCase()).concat(".path");
		String propVal = PropertiesLoader.getProperty(propKey);
		if (Utils.isEmpty(propVal))  // can't be, if properties settings are valid
			throw new IllegalArgumentException("No property found for: ".concat(propKey));
		return propVal;
	}

	public static ResourceTypeHandler valueOf(final String name)
			throws NullPointerException, IllegalArgumentException {
		if (name == null)
			throw new NullPointerException();

		ResourceTypeHandler rt = types.get(name);
		if (rt == null)
			throw new IllegalArgumentException();
		return rt;
	}

	public static boolean isValid(final String name) {
		return types.containsKey(name);
	}
	
	public static ResourceTypeHandler getDefaultResourceType(final String name) {
		ResourceTypeHandler rt = getResourceType(name);
		return rt == null ? FILE : rt;
	}

	public static ResourceTypeHandler getResourceType(final String name) {
		try {
			return ResourceTypeHandler.valueOf(name);
		} catch (Exception e) {
			return null;
		}
	}
	
	@Override
	public boolean equals(Object obj) {
		try {
			ResourceTypeHandler rt = (ResourceTypeHandler) obj;
			return name.equals(rt.getName());
		} catch (ClassCastException e) {
			return false;
		}
	}
	
	@Override
	public String toString() {
		return name;
	}
}
