/*
 * FCKeditor - The text editor for Internet - http://www.fckeditor.net
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 * 
 * == BEGIN LICENSE ==
 * 
 * Licensed under the terms of any of the following licenses at your
 * choice:
 * 
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 * 
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 * 
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 * 
 * == END LICENSE ==
 */
package net.fckeditor.handlers;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import net.fckeditor.SessionData;

/**
 * Handler for session based data provided by {@link SessionData}.
 * 
 * @version $Id: SessionDataHandler.java 1618 2008-02-25 11:53:14Z th-schwarz $
 */
public class SessionDataHandler {
	private static Logger logger = LoggerFactory.getLogger(SessionDataHandler.class);
	private static SessionData sessionData = null;

	static {
		// try to instanciate the SessionData object
		String fqcn = PropertiesLoader.getProperty("connector.sessionDataImpl");
		if (fqcn == null)
			logger.warn("No property found for SessionData implementation, any user action is disabled!");
		else {
			try {
				@SuppressWarnings("unchecked")
				Class clazz = Class.forName(fqcn);
				sessionData = (SessionData) clazz.newInstance();
				logger.info("SessionData object successfull instanciated!");
			} catch (Exception e) {
				logger.error("Couldn't instanciate the class [".concat(fqcn).concat(
				        "], any user action of the ConnectorServlet is disabled!"), e);
			}
		}
	}

	/**
	 * Just a wrapper to {@link SessionData#isEnabledForFileBrowsing(HttpServletRequest)}.
	 * 
	 * @param servletRequest
	 * @return {@link SessionData#isEnabledForFileBrowsing(HttpServletRequest)} or false, if
	 *         sessionData isn't set.
	 */
	public static boolean isEnabledForFileBrowsing(final HttpServletRequest servletRequest) {
		return (sessionData != null && sessionData.isEnabledForFileBrowsing(servletRequest));
	}

	/**
	 * Just a wrapper to {@link SessionData#isEnabledForFileUpload(HttpServletRequest)}.
	 * 
	 * @param request
	 * @return {@link SessionData#isEnabledForFileUpload(HttpServletRequest)} or false, if
	 *         sessionData isn't set.
	 */
	public static boolean isEnabledForFileUpload(final HttpServletRequest request) {
		return (sessionData != null && sessionData.isEnabledForFileUpload(request));
	}

	/**
	 * Getter for the user's file path.<br>
	 * Method is used by other handlers only!
	 * 
	 * @param request
	 * @return {@link SessionData#getUserFilesPath(HttpServletRequest} or null, if sessionData is
	 *         null.
	 */
	protected static String getUserFilePath(final HttpServletRequest request) {
		return (sessionData != null) ? sessionData.getUserFilesPath(request) : null;
	}
}
