﻿/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

CKEDITOR.themes.add( 'default',
{
	build : function( editor, themePath )
	{
		editor.element.hide();

		var name = editor.name;
		
		var topHtml		= editor.fire( 'themespace', { space : 'top', html : '' } ).html;
		var middleHtml	= editor.fire( 'themespace', { space : 'middle', html : '' } ).html;
		var bottomHtml	= editor.fireOnce( 'themespace', { space : 'bottom', html : '' } ).html;

		var table = CKEDITOR.dom.element.createFromHtml( [
			'<table id="cke_', name, '" class="cke_editor" border="1" cellspacing="0" cellpadding="0"><tbody>' +
				'<tr', topHtml		? '' : ' style="display:none"', '><td id="cke_top_'		, name, '" class="cke_top">'	, topHtml	, '</td></tr>' +
				'<tr', middleHtml	? '' : ' style="display:none"', '><td id="cke_middle_'	, name, '" class="cke_middle">'	, middleHtml, '</td></tr>' +
				'<tr', bottomHtml	? '' : ' style="display:none"', '><td id="cke_bottom'	, name, '" class="cke_bottom">'	, bottomHtml, '</td></tr>' +
			'</tbody></table>' ].join('') );

		table.insertAfter( editor.element );

		editor.fireOnce( 'themeloaded' );
		editor.fireOnce( 'uiready' );
	}
});

CKEDITOR.editor.prototype.getThemeSpace = function( spaceName )
{
	var spacePrefix = 'cke_' + spaceName;
	var space = this._[ spacePrefix ] || 
		( this._[ spacePrefix ] = new CKEDITOR.dom.element.getById( spacePrefix + '_' + this.name ) );
	return space;
};
