﻿/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

/**
 * @fileOverview The "sourcearea" plugin. It registers the "source" editing
 *		mode, which displays the raw data being edited in the editor.
 */

CKEDITOR.plugins.add( 'sourcearea',
{
	init : function( editor, pluginPath )
	{
		editor.on( 'editingBlockReady', function()
			{
				var textarea;

				editor.addMode( 'source',
					{
						load : function( holderElement, data )
						{
							// Create the source area <textarea>.
							textarea = new CKEDITOR.dom.element( 'textarea' );
							textarea.setAttribute( 'dir', 'ltr' );
							textarea.addClass( 'cke_source' );
							textarea.setStyles({
								width	: '100%',
								height	: '100%',
								resize	: 'none',
								outline	: 'none',
								'text-align' : 'left' });

							// Set the <textarea> value.
							this.loadData( data );

							// Reset the holder element and append the
							// <textarea> to it.
							holderElement.setHtml( '' );
							holderElement.append( textarea );
						},

						loadData : function( data )
						{
							textarea.$.value = data;
						},

						getData : function()
						{
							return textarea.$.value;
						},

						unload : function( holderElement )
						{
							textarea = null;
						}
					});
			});
	}
});
