﻿/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

/**
 * @fileOverview Defines the {@link CKEDITOR.dom.document} class, which
 *		represents a DOM document.
 */

/**
 * Represents a DOM document.
 * @constructor
 * @param {Object} domDocument A native DOM document.
 * @example
 * var document = new CKEDITOR.dom.document( document );
 */
CKEDITOR.dom.document = function( domDocument )
{
	/**
	 * The native DOM document represented by this class instance.
	 * @type Object
	 * @example
	 */
	this.$ = domDocument;
};

CKEDITOR.dom.document.prototype =
{
	/**
	 * Appends a CSS file to the document.
	 * @param {String} cssFileUrl The CSS file URL.
	 * @example
	 * <b>CKEDITOR.document.appendStyleSheet( '/mystyles.css' )</b>;
	 */
	appendStyleSheet : function( cssFileUrl )
	{
		if ( this.$.createStyleSheet )
			this.$.createStyleSheet( cssFileUrl );
		else
		{
			var link = new CKEDITOR.dom.element( 'link' );
			link.setAttributes(
				{
					rel		:'stylesheet',
					type	: 'text/css',
					href	: cssFileUrl
				});

			this.getHead().append( link );
		}
	},

	/**
	 * Determines whether the specified object is equal to the current object.
	 * @param {Object} object The object to compare with the current object.
	 * @returns {Boolean} "true" if the object is equal.
	 * @example
	 * var doc = new CKEDITOR.dom.document( document );
	 * alert( doc.equals( CKEDITOR.document ) );  // "true"
	 * alert( doc == CKEDITOR.document );         // "false"
	 */
	equals : function( object )
	{
		return ( object && object.$ === this.$ );
	},

	/**
	 * Gets and element based on its id.
	 * @param {String} elementId The element id.
	 * @returns {CKEDITOR.dom.element} The element instance, or null if not found.
	 * @example
	 * var element = <b>CKEDITOR.document.getById( 'myElement' )</b>;
	 * alert( element.getId() );  // "myElement"
	 */
	getById : function( elementId )
	{
		var $ = this.$.getElementById( elementId );
		return $ ? new CKEDITOR.dom.element( $ ) : null;
	},

	/**
	 * Gets the &lt;head&gt; element for this document.
	 * @returns {CKEDITOR.dom.element} The &lt;head&gt; element.
	 * @example
	 * var element = <b>CKEDITOR.document.getHead()</b>;
	 * alert( element.getName() );  // "head"
	 */
	getHead : function()
	{
		var head = this.$.getElementsByTagName( 'head' )[0];
		head = new CKEDITOR.dom.element( head );

		return (
		/** @ignore */
		this.getHead = function()
			{
				return head;
			})();
	},

	/**
	 * Gets the &lt;body&gt; element for this document.
	 * @returns {CKEDITOR.dom.element} The &lt;body&gt; element.
	 * @example
	 * var element = <b>CKEDITOR.document.getBody()</b>;
	 * alert( element.getName() );  // "body"
	 */
	getBody : function()
	{
		var body = new CKEDITOR.dom.element( this.$.body );

		return (
		/** @ignore */
		this.getBody = function()
			{
				return body;
			})();
	},

	/**
	 * Get's the window object that holds this document.
	 * @returns {CKEDITOR.dom.window} The window object.
	 * @example
	 */
	getWindow : function()
	{
		var win = new CKEDITOR.dom.window( this.$.parentWindow || this.$.defaultView );

		return (
		/** @ignore */
		this.getWindow = function()
			{
				return win;
			})();
	}
};
