﻿/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

/**
 * @fileOverview Defines the {@link CKEDITOR.tools} object, which constains
 *		utility functions.
 */

/**
 * Utility functions.
 * @namespace
 * @example
 */
CKEDITOR.tools =
{
	/**
	 * Evaluates a script in a window (global) scope.
	 * @param {String} script The script code to be evaluated.
	 * @param {Object} [win] The target window. Defaults to the current window.
	 * @example
	 * var script = 'function sample() { alert( "Go!" ); }';
	 *
	 * // Evaluates a script in the current window.
	 * CKEDITOR.tools.globalEval( script );
	 *
	 * // Evaluates a script in the parent window.
	 * CKEDITOR.tools.globalEval( script, window.parent );
	 *
	 * // Alerts "Go!" twice.
	 * window.sample();
	 * window.parent.sample();
	 */
	globalEval : function( script, win )
	{
		if ( !win )
			win = window;

		if ( win.execScript )
			win.execScript( script );	// IE
		else if ( CKEDITOR.env.webkit )
		{
			// win.eval in Safari executes in the current window environment,
			// instead of win. The following should make it work.
			var doc = win.document;
			var scriptEl = doc.createElement('script');
			scriptEl.appendChild( doc.createTextNode( script ) );
			doc.documentElement.appendChild( scriptEl );
		}
		else
			eval.call( win, script );
	},

	/**
	 * Copy the properties from one object to another. By default, properties
	 * already present in the target object <strong>are not</strong> overwritten.
	 * @param {Object} target The object to be extended.
	 * @param {Object} source The object from which copy properties.
	 * @param {Boolean} [overwrite] Indicates that properties already present
	 *		in the target object must be overwritten.
	 * @returns {Object} the extended object (target).
	 * @example
	 * // Create the sample object.
	 * var myObject =
	 * {
	 *     prop1 : true
	 * };
	 *
	 * // Extend the above object with two properties.
	 * CKEDITOR.tools.extend( myObject,
	 *     {
	 *         prop2 : true,
	 *         prop3 : true
	 *     } );
	 *
	 * // Alert "prop1", "prop2" and "prop3".
	 * for ( var p in myObject )
	 *     alert( p );
	 */
	extend : function( target, source, overwrite )
	{
		for ( var propertyName in source )
		{
			if ( overwrite || target[ propertyName ] == undefined )
				target[ propertyName ] = source[ propertyName ];
		}
		return target;
	},

	/**
	 * Checks if an object is an Array.
	 * @param {Object} object The object to be checked.
	 * @type Boolean
	 * @returns <i>true</i> if the object is an Array, otherwise <i>false</i>.
	 * @example
	 * alert( CKEDITOR.tools.isArray( [] ) );      // "true"
	 * alert( CKEDITOR.tools.isArray( 'Test' ) );  // "false"
	 */
	isArray : function( object )
	{
		return ( !!object && object instanceof Array );
	},

	/**
	 * Transforms a CSS property name to its relative DOM style name.
	 * @param {String} cssName The CSS property name.
	 * @returns {String} The transformed name.
	 * @example
	 * alert( CKEDITOR.tools.cssStyleToDomStyle( 'background-color' ) );  // "backgroundColor"
	 * alert( CKEDITOR.tools.cssStyleToDomStyle( 'float' ) );             // "cssFloat"
	 */
	cssStyleToDomStyle : function( cssName )
	{
		if ( cssName == 'float' )
			return 'cssFloat';
		else
		{
			return cssName.replace( /-./g, function( match )
				{
					return match.substr( 1 ).toUpperCase();
				});
		}
	},

	/**
	 * Replace special HTML characters in a string with their relative HTML
	 * entity values.
	 * @param {String} text The string to be encoded.
	 * @returns {String} The encode string.
	 * @example
	 * alert( CKEDITOR.tools.htmlEncode( 'A > B & C < D' ) );  // "A &amp;gt; B &amp;amp; C &amp;lt; D"
	 */
	htmlEncode : function( text )
	{
		var standard = function( text )
		{
			var span = new CKEDITOR.dom.element( 'span' );
			span.setText( text );
			return span.getHtml();
		};

		this.htmlEncode = ( standard( '>' ) == '>' ) ?
			function( text )
			{
				// WebKit does't encode the ">" character, which makes sense, but
				// it's different than other browsers.
				return standard( text ).replace( />/g, '&gt;' );
			} :
			standard;

		return this.htmlEncode( text );
	},

	/**
	 * Gets a unique number for this CKEDITOR execution session. It returns
	 * progressive numbers starting at 1.
	 * @returns {Number} A unique number.
	 */
	getNextNumber : (function()
	{
		var last = 0;
		return function()
		{
			return ++last;
		};
	})()
};
