<?php
/*
 * FCKpackager - JavaScript Packager and Compressor - http://www.fckeditor.net
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

class FCKStringsProcessor
{
	var $_ProtectedStrings ;

	function FCKStringsProcessor()
	{
		$_ProtectedStrings = array() ;
	}

	function ProtectStrings( $source )
	{
		// Catches string literals, regular expressions and conditional comments.
		return preg_replace_callback(
			'/(?:("|\').*?(?<!\\\\)\1)|(?:(?<![\*\/\\\\])\/[^\/\*].*?(?<!\\\\)\/(?=([\.\w])|(\s*[,;}\)])))|(?s:\/\*@(?:cc_on|if|elif|else|end).*?@\*\/)/',
			array( &$this, '_ProtectStringsMatch' ), $source ) ;
	}

	function _ProtectStringsMatch( $match )
	{
		$this->_ProtectedStrings[] = $match[0] ;
		return '@' . ( count( $this->_ProtectedStrings ) - 1 ) . '@' ;
	}

	function ConcatProtectedStrings( $source )
	{
		return preg_replace_callback(
			'/@\d+@(?>@\d+@|\+)+@\d+@/',
			array( &$this, '_ConcatProtectedStringsMatch' ), $source ) ;
	}

	function _ConcatProtectedStringsMatch( $match )
	{
		// $match[0] is something like @2@+@3@+@4@+@5@

		$indexes = explode( '@+@', trim( $match[0], '@') ) ;

		$leftIndex	= (int)$indexes[0] ;
		$rightPosition = 1 ;

		$output = '@' . $leftIndex . '@' ;

		while( $rightPosition < count( $indexes ) )
		{
			$rightIndex	= (int)$indexes[ $rightPosition ] ;

			$left	= $this->_ProtectedStrings[ $leftIndex ] ;
			$right	= $this->_ProtectedStrings[ $rightIndex ] ;

			if ( strncmp( $left, $right, 1 ) == 0 )
			{
				$left = substr_replace( $left, '', strlen( $left ) - 1, 1 ) ;
				$right = substr_replace( $right, '', 0, 1 ) ;

				$this->_ProtectedStrings[ $leftIndex ] = $left . $right ;
				$this->_ProtectedStrings[ $rightIndex ] = '' ;
			}
			else
			{
				$leftIndex = $rightIndex ;
				$output .= '+@' . $leftIndex . '@' ;
			}

			$rightPosition++ ;
		}

		return $output ;
	}

	function RestoreStrings( $source )
	{
		return preg_replace_callback(
			'/@(\d+)@/',
			array( &$this, '_RestoreStringsMatch' ), $source ) ;
	}

	function _RestoreStringsMatch( $match )
	{
		return $this->_ProtectedStrings[ (int)$match[1] ] ;
	}
}

?>
