﻿/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

/**
 * @fileOverview The "elementspath" plugin. It shows all elements in the DOM
 *		parent tree relative to the current selection in the editing area.
 */

CKEDITOR.plugins.add( 'elementspath',
{
	init : function( editor, pluginPath )
	{
		var spaceId = 'cke_path_' + editor.name;
		var spaceElement;
		var getSpaceElement = function()
		{
			if ( !spaceElement )
				spaceElement = CKEDITOR.document.getById( spaceId );
			return spaceElement;
		};

		editor.on( 'themeSpace', function( event )
			{
				if ( event.data.space == 'bottom' )
					event.data.html += '<div id="' + spaceId + '" class="cke_path"><br></div>';
			});

		editor.on( 'selectionChange', function()
			{
				var element = this.getSelection().getStartElement(),
					html = [],
					elementsList = this._.elementsPathList = [];

				while ( element )
				{
					var index = elementsList.push( element ) - 1;
					var name = element.getName();
					html.unshift( '<a href="element:', name, '" onclick="CKEDITOR._.elementsPathClick( \'', this.name, '\',', index, ');return false;">', name, '</a>' );

					if ( name == 'body' )
						break;

					element = element.getParent();
				}

				getSpaceElement().setHtml( html.join('') );
			});

		editor.on( 'contentDomUnload', function()
			{
				getSpaceElement().setHtml( '<br>' );
			});
	}
});

/**
 * Handles the click on an element in the element path.
 * @private
 */
CKEDITOR._.elementsPathClick = function( instanceName, elementIndex )
{
	var editor = CKEDITOR.instances[ instanceName ];
	editor.focus();

	var element = editor._.elementsPathList[ elementIndex ];
	editor.getSelection().selectElement( element );
};
