<?php
/*
 * FCKpackager - JavaScript Packager and Compressor - http://www.fckeditor.net
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

require_once( 'fckstringsprocessor.inc' ) ;
require_once( 'fckfunctionprocessor.inc' ) ;

class FCKJavaScriptCompressor
{
	function FCKJavaScriptCompressor()
	{}

	// Call it statically. E.g.: FCKJavaScriptCompressor::Compress( ... )
	function Compress( $script, $constantsProcessor )
	{
		// Concatenates all string with escaping new lines strings (ending with \).
		$script = preg_replace(
			'/\\\\[\n\r]+/s',
			'\n', $script ) ;

		$stringsProc = new FCKStringsProcessor() ;

		// Protect the script strings.
		$script = $stringsProc->ProtectStrings( $script ) ;

		// Remove "/* */" comments
		$script = preg_replace(
			'/(?<!\/)\/\*.*?\*\//s',
			'', $script ) ;

		// Remove "//" comments
		$script = preg_replace(
				'/\/\/.*$/m',
				'', $script ) ;
		
		// Remove spaces before the ";" at the end of the lines
		$script = preg_replace(
			'/\s*(?=;\s*$)/m',
			'', $script ) ;

		// Remove spaces next to "="
		$script = preg_replace(
			'/^([^"\'\r\n]*?)\s*=\s*/m',
			'$1=', $script ) ;

		// Remove spaces on "()": "( content )" = "(content)"
		$script = preg_replace(
			'/^([^\r\n""\']*?\()\s+(.*?)\s+(?=\)[^\)]*$)/m',
			'$1$2', $script ) ;

		// Concatenate lines that doesn't end with [;{}] using a space
		$script = preg_replace(
			'/(?<![;{}\n\r\s])\s*[\n\r]+\s*(?![\s\n\r{}])/s',
			' ', $script ) ;

		// Concatenate lines that end with "}" using a ";", except for "else",
		// "while", "catch" and "finally" cases, or when followed by, "'", ";",
		// "}" or ")".
		$script = preg_replace(
			'/\s*}\s*[\n\r]+\s*(?!\s*(else|catch|finally|while|[}\),;:]))/s',
			'};', $script ) ;

		// Remove blank lines, spaces at the begining or the at the end and \n\r
		$script = preg_replace(
			'/(^\s*$)|(^\s+)|(\s+$\n)/m',
			'', $script ) ;

		// Remove the spaces between statements.
		$script = FCKJavaScriptCompressor::_RemoveInnerSpaces( $script ) ;

		// Process constants.	// CHECK
		if ( $constantsProcessor->HasConstants )
			$script = $constantsProcessor->Process( $script );

		// Replace "new Object()".
		$script = preg_replace(
			'/new Object\(\)/',
			'{}', $script ) ;

		// Replace "new Array()".
		$script = preg_replace(
			'/new Array\(\)/',
			'[]', $script ) ;

		// Process function contents, renaming parameters and variables.
		$script = FCKJavaScriptCompressor::_ProcessFunctions( $script ) ;

		// Join consecutive string concatened with a "+".
		$script = $stringsProc->ConcatProtectedStrings( $script );

		// Restore the protected script strings.
		$script = $stringsProc->RestoreStrings( $script );

		return $script ;
	}

	function _RemoveInnerSpaces( $script )
	{
		return preg_replace_callback(
			'/(?:\s*[=?:+\-*\/&,;><|!]\s*)|(?:[(\[]\s+)|(?:\s+[)\]])/',
			array( 'FCKJavaScriptCompressor', '_RemoveInnerSpacesMatch' ), $script ) ;
	}

	function _RemoveInnerSpacesMatch( $match )
	{
		return trim( $match[0] ) ;
	}

	function _ProcessFunctions( $script )
	{
		return preg_replace_callback(
			'/function(?:\s+\w+)?\s*\(\s*([^\)]*?)\s*\)\s*({(?:(?>[^{}]*)|(?2))*})+/',
			array( 'FCKJavaScriptCompressor', '_ProcessFunctionMatch' ), $script ) ;
	}

	function _ProcessFunctionMatch( $match )
	{
		// Creates an array with the parameters names ($match[1]).
		if ( strlen( trim( $match[1] ) ) == 0 )
			$parameters = array() ;
		else
			$parameters = preg_split( '/\s*,\s*/', trim( $match[1] ) ) ;

		$hasfuncProcessor = isset( $GLOBALS['funcProcessor'] ) ;

		if ( $hasfuncProcessor != TRUE )
			$GLOBALS['funcProcessor'] = new FCKFunctionProcessor( $match[0], $parameters, false ) ;
		else
		{
			$GLOBALS['funcProcessor']->_Function = $match[0];
			$GLOBALS['funcProcessor']->_Parameters = $parameters;
		}

		$processed = $GLOBALS['funcProcessor']->Process() ;
		
		$processed = substr_replace( $processed, '', 0, 8 ) ;

		$processed = FCKJavaScriptCompressor::_ProcessFunctions( $processed ) ;

		if ( $hasfuncProcessor != TRUE )
			unset( $GLOBALS['funcProcessor'] ) ;
		
		return 'function'. $processed ;
	}
}

?>
