/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

CKEDITOR.plugins.add( 'dialog' );

CKEDITOR.DIALOG_RESIZE_NONE = 0;
CKEDITOR.DIALOG_RESIZE_RESIZE_WIDTH = 1;
CKEDITOR.DIALOG_RESIZE_RESIZE_HEIGHT = 2;
CKEDITOR.DIALOG_RESIZE_RESIZE_BOTH = 3;

CKEDITOR.dialog = function( editor, dialogName )
{
	if ( arguments.length < 2 )
		return;

	// Load the dialog definition.
	var definition = CKEDITOR.dialog._.dialogDefinitions[dialogName];
	if ( typeof( definition ) != 'function' )
	{
		alert( 'Error: The dialog "' + dialogName + '" is not defined.' );
		return;
	}
	definition = CKEDITOR.tools.extend( {}, CKEDITOR.dialog._.defaultDialogDefinition, definition() );
	if ( !( definition.title && definition.contents ) )
	{
		alert( 'Error: The dialog "' + dialogName + '" is missing its title or contents.' );
		return;
	}
	if ( definition.contents.length < 1 )
	{
		alert( 'Error: The dialog "' + dialogName + '" has no contents.' );
		return;
	}

	// Initialize some basic parameters.
	if ( !this._ )
		this._ = {};
	CKEDITOR.tools.extend( this._, {
			editor : editor,
			element : editor.theme.buildDialog( editor ),
			name : dialogName,
			definition : definition,
			isShown : false,
			size : { width : 0, height : 0 },
			contents : {}
		});

	// Initialize the parts map.
	var element = this._.element.getFirst();
	this._.parts = {
		'tl' : [0,0],
		't' : [0,1],
		'tr' : [0,2],
		'l' : [1,0],
		'c' : [1,1],
		'r' : [1,2],
		'bl' : [2,0],
		'b' : [2,1],
		'br' : [2,2],
		'title' : [1,1,0],
		'tabs' : [1,1,1],
		'bridge' : [1,1,2],
		'contents' : [1,1,3],
		'buttons' : [1,1,4]
	};
	for ( var i in this._.parts )
		this._.parts[i] = element.getChild( this._.parts[i] );

	// Initialize the tab and page map.
	this._.tabs = {};

	// Insert the title.
	( new CKEDITOR.dom.text( definition.title, CKEDITOR.document ) ).appendTo( this._.parts.title );

	// Insert the tabs and contents.
	for ( var i = 0 ; i < definition.contents.length ; i++ )
		this.addPage( definition.contents[i] );

	var classRegex = /cke_dialog_tab(\s|$|_)/;
	this._.parts['tabs'].on( 'click', function( evt )
			{
				var target = evt.data.getTarget(), firstNode = target, id, page;

				// If we aren't inside a tab, bail out.
				if ( !classRegex.test( target.$.className ) )
					return;

				// Find the outer <span> container of the tab.
				while ( target.getName() == 'div' && classRegex.test( target.$.className ) )
					target = target.getParent();
				id = target.$.id.substr( 0, target.$.id.lastIndexOf( '_' ) );
				this.selectPage( id );
			}, this );
}

CKEDITOR.dialog.prototype = 
{
	resize : (function()
	{
		// Define the function for resizing dialog parts at load to speed up
		// the actual resize operation.
		var setSize = function( dialog, partName, width, height )
		{
			var element = partName ? dialog._.parts[partName] : dialog._.element.getFirst();
			element.setStyles( {
				width : Math.max( width || 0, 0 ) + 'px',
				height : Math.max( height || 0, 0 ) + 'px'
			} );
		}

		// Dialog parts dimensions.
		//  16x16  |  ?x16  |  16x16
		//  16x?   |  ?x?   |  16x?
		//  30x51  |  ?x51  |  30x51
		return function( width, height )
		{
			setSize( this, 't', width - 32, 16 );
			setSize( this, 'l', 16, height - 67 );
			setSize( this, 'c', width - 32, height - 67 );
			setSize( this, 'r', 16, height - 67 );
			setSize( this, 'b', width - 60, 51 );
			setSize( this, null, width, height );
			this._.size = { width : width, height : height };
		}
	})(),

	move : function( x, y )
	{
		// The dialog may be fixed positioned or absolute positioned. Ask the
		// browser what is the current situation first.
		var isFixed = this._.element.getFirst().getComputedStyle( 'position' ) == 'fixed';

		// If not fixed positioned, add scroll position to the coordinates.
		if ( !isFixed )
		{
			var scrollPosition = CKEDITOR.document.getWindow().getScrollPosition();
			x += scrollPosition.x;
			y += scrollPosition.y;
		}

		this._.element.getFirst().setStyles(
				{
					'left' : x + 'px',
					'top' : y + 'px'
				});
	},

	show : function()
	{
		// Insert the dialog's element to the root document.
		var element = this._.element;
		var definition = this._.definition;
		if ( element.getParent() != CKEDITOR.document.getBody() )
			element.appendTo( CKEDITOR.document.getBody() );

		// First, set the dialog to an appropriate size.
		this.resize( definition.minWidth, definition.minHeight );

		// Rearrange the dialog to the middle of the window.
		var viewSize = CKEDITOR.document.getWindow().getViewPaneSize();
		this.move( ( viewSize.width - this._.size.width ) / 2, ( viewSize.height - this._.size.height ) / 2 );
		
		// Select the first tab by default.
		this.selectPage( this._.definition.contents[0].id );
	},

	hide : function()
	{
		// Remove the dialog's element from the root document.
		var element = this._.element;
		if ( !element.getParent() )
			return;
		element.remove();
	},

	addPage : function( contents, index )
	{
		var pageHtml = [ '<div class="cke_dialog_page_contents">' ],
			page,
			tab,
			elements = contents.elements;

		for ( var i = 0 ; i < elements.length ; i++ )
		{
			var item = elements[i],
				builder = CKEDITOR.dialog._.uiElementBuilders[ item.type ];
			if ( !builder )
				continue;
			builder.build( this, item, pageHtml );
		}
		pageHtml.push( '</div>' );

		page = CKEDITOR.dom.element.createFromHtml( pageHtml.join( '' ) );
		tab = CKEDITOR.dom.element.createFromHtml( [
				'<span><div class="cke_dialog_tab">',
					'<div class="cke_dialog_tab_left"></div>',
					'<div class="cke_dialog_tab_center">',
						CKEDITOR.tools.htmlEncode( contents.label ),
					'</div>',
					'<div class="cke_dialog_tab_right"></div>',
				'</div></span>'
			].join( '' ) );
		this._.tabs[ contents.id ] = [ tab, page ];
		tab.getFirst().unselectable();
		page.appendTo( this._.parts['contents'] );
		tab.appendTo( this._.parts['tabs'] );
		tab.setAttribute( 'id', contents.id + '_' + CKEDITOR.tools.getNextNumber() );

	},

	selectPage : function( id )
	{
		var bridge = this._.parts.bridge;

		// Hide the non-selected tabs and pages.
		for ( var i in this._.tabs )
		{
			var tab = this._.tabs[i][0],
				page = this._.tabs[i][1];
			if ( i != id )
			{
				tab.removeClass( 'cke_dialog_tab_selected' );
				page.hide();
			}
		}

		var selected = this._.tabs[id];
		selected[0].addClass( 'cke_dialog_tab_selected' );
		// Place the bridge just under the selected tab. Count 1px left and right
		// of the tab as border space.
		bridge.setStyles(
				{
					left : ( selected[0].getFirst().$.offsetLeft + 17 || 0 ) + 'px',
					width : ( selected[0].getFirst().$.offsetWidth - 2 || 0 ) + 'px'
				});
		selected[1].show();
	}
};

CKEDITOR.tools.extend( CKEDITOR.dialog,
	{
		add: function( name, callback )
		{
			this._.dialogDefinitions[name] = callback;
		},

		okButton : null,

		cancelButton : null,

		addUIElement : function( typeName, builder )
		{
			this._.uiElementBuilders[typeName] = builder;
		},

		storedDialogs : {}
	});

CKEDITOR.dialog._ = 
{
	defaultDialogDefinition :
	{
		resizable : CKEDITOR.DIALOG_RESIZE_NONE,
		minWidth : 600,
		minHeight : 400,
		buttons : [ CKEDITOR.dialog.okButton, CKEDITOR.dialog.cancelButton ],
		onOk : function(){ alert( 'ok called' ); },
		onCancel : function(){ alert( 'cancel caled' ); },
		onLoad : function(){ alert( 'onload called' ); }
	},

	uiElementBuilders : {},

	dialogDefinitions : {
		testOnly : function()
		{
			return {
				title : 'Test Dialog',
				resizable : CKEDITOR.DIALOG_RESIZE_NONE,
				minWidth : 500,
				minHeight : 400,
				contents : [
					{
						id : 'tab1',
						label : 'First Tab',
						title : 'First Tab Title',
						accessKey : 'Q',
						elements : [
							{
								type : 'vbox',
								children : []
							}
						]
					},

					{
						id : 'tab2',
						label : 'Second Tab',
						title : 'Second Tab Title',
						accessKey : 'W',
						elements : [
							{
								type : 'vbox',
								children : []
							}
						]
					},

					{
						id : 'tab3',
						label : 'Third Tab',
						title : 'Third Tab Title',
						accessKey : 'E',
						elements : [
							{
								type : 'vbox',
								children : []
							}
						]
					}
				]
			};
		}
	}
};

CKEDITOR.ui.dialog = 
{
	uiElement : function( dialog, elementDefinition, htmlList, nodeNameArg, stylesArg, attributesArg, contentsArg )
	{
		if (arguments.length < 4 )
			return;

		var id = this.id = elementDefinition.id,
			nodeName = ( nodeNameArg.call ? nodeNameArg( elementDefinition ) : nodeNameArg ) || 'div',
			html = [ '<', nodeName, ' ' ],
			styles = ( stylesArg && stylesArg.call ? stylesArg( elementDefinition ) : stylesArg ) || {},
			attributes = ( attributesArg && attributesArg.call ? attributesArg( elementDefinition ) : attributesArg ) || {},
			innerHTML = ( contentsArg && contentsArg.call ? contentsArg( elementDefinition ) : contentsArg ) || '';

		// Set the id.
		if ( id )
		{
			html.push( 'id="' + id + '" ' );
			dialog._.contents[id] = this;
		}

		// Set the type and definition CSS class names.
		var classes = {};
		classes[ 'cke_dialog_ui_' + elementDefinition.type ] = 1;
		if ( elementDefinition.className )
			classes[ elementDefinition.className ] = 1;
		var attributeClasses = ( attributes.class && attributes.class.split ) ? attributes.class.split( ' ' ) : [];
		for ( var i = 0 ; i < attributeClasses.length ; i++ )
		{
			if ( attributeClasses[i] )
				classes[ attributeClasses[i] ] = 1;
		}
		var finalClasses = [];
		for ( var i in classes )
			finalClasses.push( i );
		attributes.class = finalClasses.join( ' ' );

		// Write the inline CSS styles.
		html.push( 'style="' );
		for ( var i in styles )
			html.push( i + ':' + styles[i] + ';' );
		html.push( '" ' );

		// Write the attributes.
		for ( var i in attributes )
			html.push( i + '="' + CKEDITOR.tools.htmlEncode( attributes[i] ) + '" ');

		// Write the content HTML.
		html.push( '>', innerHTML, '</', nodeName, '>' );

		// Add contents to the parent HTML array.
		htmlList.push( html.join( '' ) );
	},

	hbox : function( dialog, elementDefinition, htmlList, stylesArg, attributesArg )
	{
		if (arguments.length < 3 )
			return;

		if ( !this._ )
			this._ = {};
		var children = this._.children = [];
		var innerHTML = function( innerDefinition )
		{
			var html = [];
			for ( var i = 0 ; i < innerDefinition.children.length ; i++ )
			{
				var child = innerDefinition.children[i],
					type = child.type;
				html.push( '<div style="float:left;' );
				if ( innerDefinition.widths && isFinite( parseFloat( innerDefinition.widths[i] ) ) )
					html.push( 'width:' + innerDefinition.widths[i] + 'px;' );
				if ( innerDefinition.height && isFinite( parseFloat( innerDefinition.height ) ) )
					html.push( 'height:' + innerDefinition.height + 'px;' );
				html.push( '">' );
				children.push( CKEDITOR.dialog._.uiElementBuilders[type].build( dialog, child, html ) );
				html.push( '</div>' );
			}
			return html.join( '' );
		}
		CKEDITOR.ui.dialog.uiElement.call(this, dialog, elementDefinition, htmlList, 'div', stylesArg, attributesArg, innerHTML );
	},

	vbox : function( dialog, elementDefinition, htmlList, stylesArg, attributesArg )
	{
		if (arguments.length < 3 )
			return;

		if ( !this._ )
			this._ = {};
		var children = this._.children = [];
		var innerHTML = function( innerDefinition )
		{
			var html = [];
			for ( var i = 0 ; i < innerDefinition.children.length ; i++ )
			{
				var child = innerDefinition.children[i],
					type = child.type;
				html.push( '<div style="' );
				if ( innerDefinition.width && isFinite( parseFloat( innerDefinition.width ) ) )
					html.push( 'width:' + innerDefinition.width + 'px;' );
				if ( innerDefinition.heights && isFinite( parseFloat( innerDefinition.heights[i] ) ) )
					html.push( 'height:' + innerDefinition.heights[i] + 'px;' );
				html.push( '">' );
				children.push( CKEDITOR.dialog._.uiElementBuilders[type].build( dialog, child, html ) );
				html.push( '</div>' );
			}
			return html.join( '' );
		}
		CKEDITOR.ui.dialog.uiElement.call(this, dialog, elementDefinition, htmlList, 'div', stylesArg, attributesArg, innerHTML );
	}
};

CKEDITOR.ui.dialog.uiElement.prototype = 
{
	getElement: function()
	{
		return CKEDITOR.document.getById( this.id );
	},

	setValue : function( value )
	{
		this.getElement().value = value;
	},

	getValue : function()
	{
		return this.getElement().value;
	},

	isChanged : function()
	{
		// Override in subclasses.
		return false;
	},

	focus : function()
	{
		this.getElement().focus();
	}
};

CKEDITOR.ui.dialog.hbox.prototype = CKEDITOR.tools.extend(new CKEDITOR.ui.dialog.uiElement,
	{
		setValue : function( value )
		{
			var len = Math.min( value.length, this._.children.length );
			for ( var i = 0 ; i < len ; i++ )
				this._.children[i].setValue( value[i] );
		},

		getValue : function()
		{
			var retval = [];
			for ( var i = 0 ; i < this._.children.length ; i++ )
				retval.push( this._.children[i].getValue() );
			return retval;
		},

		isChanged : function()
		{
			var retval = false;
			for ( var i = 0 ; i < this._.children.length ; i++ )
				retval |= this._.children[i].isChanged();
			return retval;
		},

		focus : function()
		{
			this.getElement().focus();
		},

		getChild : function( indices )
		{
			if ( !indices.splice )
				indices = [ indices ];
			if ( indices.length < 2 )
				return this._.children[ indices[0] ];
			else
				return ( this._.children[ indices[0] ] && this._.children[ indices[0] ].getChild ) ?
					this._.children[ indices[0] ].getChild( indices.slice( 1, indices.length ) ) :
					null;
		}
	});

CKEDITOR.ui.dialog.vbox.prototype = CKEDITOR.ui.dialog.hbox.prototype;

CKEDITOR.tools.extend( CKEDITOR.editor.prototype,
	{
		openDialog : function( dialogName )
		{
			var dialog = CKEDITOR.dialog.storedDialogs[dialogName] || new CKEDITOR.dialog( this, dialogName );
			CKEDITOR.dialog.storedDialogs[dialogName] = dialog;
			dialog.show();
			return dialog;
		}
	});

(function()
{
	CKEDITOR.dialog.addUIElement( 'hbox',
			{
				build : function( dialog, elementDefinition, output )
				{
					return new CKEDITOR.ui.dialog.hbox( dialog, elementDefinition, output );
				}
			});

	CKEDITOR.dialog.addUIElement( 'vbox',
			{
				build : function( dialog, elementDefinition, output )
				{
					return new CKEDITOR.ui.dialog.vbox( dialog, elementDefinition, output );
				}
			});
})();
