/*
 * FCKeditor - The text editor for Internet - http://www.fckeditor.net
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 * 
 * == BEGIN LICENSE ==
 * 
 * Licensed under the terms of any of the following licenses at your
 * choice:
 * 
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 * 
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 * 
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 * 
 * == END LICENSE ==
 */
package net.fckeditor.handlers;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import net.fckeditor.connector.Connector;
import net.fckeditor.requestcycle.UserPathBuilder;

/**
 * Handler for Connector-related properties.<br />
 * Wraps to the {@link PropertiesLoader}.
 * 
 * @version $Id: ConnectorHandler.java 2474 2008-09-19 19:36:33Z mosipov $
 */
public class ConnectorHandler {
	
	private static Logger logger = LoggerFactory.getLogger(ConnectorHandler.class);
	private static Connector connector = null;
	
	static {
		
		// 3. try to instantiate the Connector object
		String fqcn = PropertiesLoader.getProperty("connector.implementation");
		if (fqcn == null)
			logger.warn("No property found for Connector implementation, any user action will be disabled!");
		else {
			try {
				Class<?> clazz = Class.forName(fqcn);
				connector = (Connector) clazz.newInstance();
				logger.info("Connector initialized to {}", connector.getClass());
			} catch (Exception e) {
				logger.error("Couldn't instantiate class [".concat(fqcn).concat(
				        "], any user action will disabled!"), e);
			}
		}
	}

	/**
	 * Getter for the <code>UserFilesPath</code>.<br>
	 * Should be use in the implementations of {@link Connector}.
	 * 
	 * @return {@link UserPathBuilder#getUserFilesPath()} or
	 *         the <code>DefaultUserFilePath</code> if {@link UserPathBuilder}
	 *         isn't set.
	 */
	public static String getUserFilesPath() {
    	String userFilePath = RequestCycleHandler.getUserFilesPath();
    	return (userFilePath != null) ? userFilePath : getDefaultUserFilesPath();
    }

	/**
	 * Getter for the default handling of files with multiple extensions.
	 * 
	 * @return <code>true</code> if single extension only should be enforced
	 *         else <code>false</code>.
	 */
	public static boolean isForceSingleExtension() {
		return Boolean.valueOf(PropertiesLoader.getProperty("connector.forceSingleExtension"));
	}

	/**
	 * TODO change JavaDoc
	 * Getter for the value to instruct the connector to return the full URL of
	 * a file/folder in the XML response rather than the absolute URL.
	 * 
	 * @return <code>true</code> if the property <code>connector.fullUrl</code> is
	 *         set else <code>false</code>.
	 */
	public static String getBaseUrl() {
		return PropertiesLoader.getProperty("connector.baseUrl");
	}

	/**
	 * Getter for the default <code>UserFilesPath</code>.
	 * 
	 * @return <code>DefaultUserFilesPath</code> (/userfiles)
	 */
	public static String getDefaultUserFilesPath() {
		return PropertiesLoader.getProperty("connector.userFilesPath");
	}
	
	/**
	 * Getter for the value to instruct the Connector to check if the uploaded
	 * image is really an image.
	 * 
	 * @return Boolean value of the property
	 *         <code>connector.secureImageUploads</code>.
	 */
	public static boolean isSecureImageUploads() {
		return Boolean.valueOf(PropertiesLoader.getProperty("connector.secureImageUploads"));
	}

	/**
	 * Getter for the implementation of {@link Connector}.
	 * 
	 * @return Implementation of {@link Connector}.
	 */
	public static Connector getConnector() {
		return connector;
	}
}
