/*
 * FCKeditor - The text editor for Internet - http://www.fckeditor.net
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 * 
 * == BEGIN LICENSE ==
 * 
 * Licensed under the terms of any of the following licenses at your
 * choice:
 * 
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 * 
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 * 
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 * 
 * == END LICENSE ==
 */
package net.fckeditor.requestcycle;

import javax.servlet.http.HttpServletRequest;

/**
 * Container for {@link ThreadLocal}s.<br>
 *
 * @version $Id: ThreadLocalData.java 2488 2008-09-22 20:22:52Z th-schwarz $
 */
public class ThreadLocalData {
	private static ThreadLocal<HttpServletRequest> servletRequest = null;
	private static ThreadLocal<Context> context = null;
	
	public static void beginRequest(final HttpServletRequest servletRequest) {
		if (servletRequest == null)
			throw new IllegalArgumentException();
		if (ThreadLocalData.servletRequest == null)
			ThreadLocalData.servletRequest = new ThreadLocal<HttpServletRequest>();
		ThreadLocalData.servletRequest.set(servletRequest);
		if (ThreadLocalData.context == null)
			ThreadLocalData.context = new ThreadLocal<Context>();
		ThreadLocalData.context.set(new Context(servletRequest));
	}
	
	public static HttpServletRequest getServletRequest() {
		return (servletRequest == null) ? null : servletRequest.get();
	}
	
	 public static Context getContext() {
		 return (context == null) ? null : context.get();
	 }
	
	/**
	 * Clear the ThreadLocals.<br>
	 * <b>Important: To prevent memory leaks we have to make sure that this method is calling at the end of each request cycle!!!</b>
	 */
	public static void endRequest() {
		servletRequest = null;
	}
}
