/*
 * FCKeditor - The text editor for Internet - http://www.fckeditor.net
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 * 
 * == BEGIN LICENSE ==
 * 
 * Licensed under the terms of any of the following licenses at your
 * choice:
 * 
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 * 
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 * 
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 * 
 * == END LICENSE ==
 */
package net.fckeditor.localization.impl;

import java.util.Locale;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

import net.fckeditor.localization.LocaleResolver;
import net.fckeditor.tool.Utils;

/**
 * This implementation simply returns the user locale with
 * {@link ServletRequest#getLocale()} but it has an advantage over the named
 * method. If the <code>Accept-Language</code> header is empty, the default
 * server locale will be returned. This behavior is undesired and can lead to
 * wrong localized messages. Instead, this implementation will only return the
 * locale if the header is not empty.
 * 
 * @version $Id: AcceptLanguageHeaderResolver.java 2492 2008-09-24 17:07:11Z mosipov $
 * 
 */
public class AcceptLanguageHeaderResolver implements LocaleResolver {

	/*
	 * (non-Javadoc)
	 * 
	 * @see net.fckeditor.localization.LocaleResolver#resolveLocale(javax.servlet.http.HttpServletRequest)
	 */
	public Locale resolveLocale(final HttpServletRequest request) {

		if (Utils.isNotEmpty(request.getHeader("Accept-Language")))
			return request.getLocale();
		else
			return null;
	}

}
