﻿/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

CKEDITOR.plugins.add( 'dialog',
	{
		requires : [ 'dialogui' ]
	});

CKEDITOR.DIALOG_RESIZE_NONE = 0;
CKEDITOR.DIALOG_RESIZE_RESIZE_WIDTH = 1;
CKEDITOR.DIALOG_RESIZE_RESIZE_HEIGHT = 2;
CKEDITOR.DIALOG_RESIZE_RESIZE_BOTH = 3;

CKEDITOR.dialog = function( editor, dialogName )
{
	if ( arguments.length < 2 )
		return;

	// Load the dialog definition.
	var definition = CKEDITOR.dialog._.dialogDefinitions[dialogName];
	if ( typeof( definition ) != 'function' )
	{
		console.log( 'Error: The dialog "' + dialogName + '" is not defined.' );
		return;
	}
	definition = CKEDITOR.tools.extend( {}, CKEDITOR.dialog._.defaultDialogDefinition, definition(), true );
	if ( !( definition.title && definition.contents ) )
	{
		console.log( 'Error: The dialog "' + dialogName + '" is missing its title or contents.' );
		return;
	}
	if ( definition.contents.length < 1 )
	{
		console.log( 'Error: The dialog "' + dialogName + '" has no contents.' );
		return;
	}

	// Initialize some basic parameters.
	if ( !this._ )
		this._ = {};
	CKEDITOR.tools.extend( this._, {
			editor : editor,
			element : editor.theme.buildDialog( editor ),
			name : dialogName,
			definition : definition,
			size : { width : 0, height : 0 },
			contents : {}
		}, true);

	// Initialize the parts map.
	var element = this._.element.getFirst(),
		i;
	this._.parts = {
		'tl' : [0,0],
		'tl_resize' : [0,0,0],
		't' : [0,1],
		't_resize' : [0,1,0],
		'tr' : [0,2],
		'tr_resize' : [0,2,0],
		'l' : [1,0],
		'l_resize' : [1,0,0],
		'c' : [1,1],
		'r' : [1,2],
		'r_resize' : [1,2,0],
		'bl' : [2,0],
		'bl_resize' : [2,0,0],
		'b' : [2,1],
		'b_resize' : [2,1,0],
		'br' : [2,2],
		'br_resize' : [2,2,0],
		'title' : [1,1,0],
		'close' : [1,1,0,0],
		'tabs' : [1,1,1],
		'bridge' : [1,1,2],
		'contents' : [1,1,3],
		'footer' : [1,1,4]
	};
	for ( i in this._.parts )
		this._.parts[i] = element.getChild( this._.parts[i] );

	// Initialize the tab and page map.
	this._.tabs = {};

	// Make the dialog an event hub.
	CKEDITOR.event.implementOn( this );

	// Initialize load, ok and cancel events.
	if ( definition.onLoad )
		this.on( 'load', definition.onLoad, this, null, CKEDITOR.tools.getNextNumber() );
	if ( definition.onOk )
		this.on( 'ok', function( evt )
				{
					if ( definition.onOk.call( this, evt ) === false )
						evt.data.hide = false;
				}, this, null, 0 );
	if ( definition.onCancel )
		this.on( 'cancel', function( evt )
				{
					if ( definition.onCancel.call( this, evt ) === false )
						evt.data.hide = false;
				}, this, null, 0);

	this.on( 'ok', function( evt )
			{
				for ( var i in this._.contents )
				{
					if ( this._.contents[i].validate && !this._.contents[i].validate( this ) )
					{
						evt.data.hide = false;
						break;
					}
				}
			}, this, null, 0 );
	this.on( 'cancel', function( evt )
			{
				for ( var i in this._.contents )
				{
					if ( this._.contents[i].isChanged() )
					{
						if ( !confirm( 'Some of the options have been changed. Are you sure to close the dialog?' ) )
							evt.data.hide = false;
						break;
					}
				}
			}, this, null, 0 );

	this._.parts.close.on( 'click', function( evt )
			{
				if ( this.fire( 'cancel', { hide : true } ).hide !== false )
					this.hide();
			}, this );

	CKEDITOR.dialog._.initDragAndDrop( this );
	CKEDITOR.dialog._.initResizeHandles( this );

	// Insert the title.
	( new CKEDITOR.dom.text( definition.title, CKEDITOR.document ) ).appendTo( this._.parts.title );

	// Insert the tabs and contents.
	for ( i = 0 ; i < definition.contents.length ; i++ )
		this.addPage( definition.contents[i] );

	var classRegex = /cke_dialog_tab(\s|$|_)/;
	this._.parts['tabs'].on( 'click', function( evt )
			{
				var target = evt.data.getTarget(), firstNode = target, id, page;

				// If we aren't inside a tab, bail out.
				if ( !classRegex.test( target.$.className ) )
					return;

				// Find the outer <span> container of the tab.
				while ( target.getName() == 'div' && classRegex.test( target.$.className ) )
					target = target.getParent();
				id = target.$.id.substr( 0, target.$.id.lastIndexOf( '_' ) );
				this.selectPage( id );
			}, this );

	// Insert buttons.
	var buttonsHtml = [];
	CKEDITOR.dialog._.uiElementBuilders.hbox.build( this,
			{
				type : 'hbox',
				className : 'cke_dialog_footer_buttons',
				widths : [],
				children : definition.buttons
			}, buttonsHtml );
	this._.parts.footer.setHtml( buttonsHtml.join( '' ) );

	CKEDITOR.skins.load( editor.config.skin, 'dialog' );
};

CKEDITOR.dialog.prototype = 
{
	resize : (function()
	{
		// Define the function for resizing dialog parts at load to speed up
		// the actual resize operation.
		var setSize = function( dialog, partName, width, height )
		{
			var element = partName ? dialog._.parts[partName] : dialog._.element.getFirst();
			if ( width )
				element.setStyle( 'width', width + 'px' );
			if ( height )
				element.setStyle( 'height', height + 'px' );
		};

		// Dialog parts dimensions.
		//  16x16  |  ?x16  |  16x16
		//  16x?   |  ?x?   |  16x?
		//  30x51  |  ?x51  |  30x51
		return function( width, height )
		{
			if ( this._.size && this._.size.width == width && this._.size.height == height )
				return;

			// TODO: Move these all to the skin.
			setSize( this, 't', width - 32, 16 );
			setSize( this, 't_resize', width - 32, null );
			setSize( this, 'l', 16, height - 67 );
			setSize( this, 'l_resize', null, height - 67 + 45 );
			setSize( this, 'c', width - 32, height - 67 );
			setSize( this, 'r', 16, height - 67 );
			setSize( this, 'r_resize', null, height - 67 + 45 );
			setSize( this, 'b', width - 60, 51 );
			setSize( this, 'b_resize', width - 60 + 28, null );
			setSize( this, null, width, height );
			this._.size = { width : width, height : height };
		};
	})(),

	getSize : function()
	{
		return CKEDITOR.tools.extend( {}, this._.size );
	},

	move : (function()
	{
		var isFixed;
		return function( x, y )
		{
			// The dialog may be fixed positioned or absolute positioned. Ask the
			// browser what is the current situation first.
			if ( isFixed === undefined )
				isFixed = this._.element.getFirst().getComputedStyle( 'position' ) == 'fixed';

			if ( this._.position && this._.position.x == x && this._.position.y == y )
				return;

			// Save the current position.
			this._.position = { x : x, y : y };

			// If not fixed positioned, add scroll position to the coordinates.
			if ( !isFixed )
			{
				var scrollPosition = CKEDITOR.document.getWindow().getScrollPosition();
				x += scrollPosition.x;
				y += scrollPosition.y;
			}

			this._.element.getFirst().setStyles(
					{
						'left' : x + 'px',
						'top' : y + 'px'
					});
		}
	})(),

	getPosition : function(){ return CKEDITOR.tools.extend( {}, this._.position ); },

	show : function()
	{
		// Insert the dialog's element to the root document.
		var element = this._.element;
		var definition = this._.definition;
		if ( !( element.getParent() && element.getParent().equals( CKEDITOR.document.getBody() ) ) )
			element.appendTo( CKEDITOR.document.getBody() );
		else
			return;

		// First, set the dialog to an appropriate size.
		this.resize( definition.minWidth, definition.minHeight );

		// Rearrange the dialog to the middle of the window.
		var viewSize = CKEDITOR.document.getWindow().getViewPaneSize();
		this.move( ( viewSize.width - this._.size.width ) / 2, ( viewSize.height - this._.size.height ) / 2 );
		
		// Select the first tab by default.
		this.selectPage( this._.definition.contents[0].id );

		// Reset all inputs back to their default value.
		for ( var i in this._.contents )
		{
			var c = this._.contents[i];
			if ( c.reset )
				c.reset();
		}

		// Set z-index.
		if ( CKEDITOR.dialog._.currentZIndex === null )
			CKEDITOR.dialog._.currentZIndex = this._.editor.config.basePopupZIndex;
		this._.element.getFirst().setStyle( 'z-index', CKEDITOR.dialog._.currentZIndex += 10 );

		// Maintain the dialog ordering and dialog cover.
		if ( CKEDITOR.dialog._.currentTop == null )
		{
			CKEDITOR.dialog._.currentTop = this;
			this._.parentDialog = null;
			CKEDITOR.dialog._.addCover( this._.editor );
		}
		else
		{
			this._.parentDialog = CKEDITOR.dialog._.currentTop;
			var parentElement = this._.parentDialog.getElement().getFirst();
			parentElement.$.style.zIndex  -= Math.floor( this._.editor.config.basePopupZIndex / 2 );
			CKEditor.dialog._.currentTop = this;
		}
		
		// Execute onLoad for the first show.
		this.fireOnce( 'load', {} );
	},

	hide : function()
	{
		// Remove the dialog's element from the root document.
		var element = this._.element;
		if ( !element.getParent() )
			return;
		element.remove();

		// Maintain dialog ordering and remove cover if needed.
		if ( this._.parentDialog == null )
			CKEDITOR.dialog._.removeCover();
		else
		{
			var parentElement = this._.parentDialog.getElement().getFirst();
			parentElement.setStyle( 'z-index', parseInt( parentElement.$.style.zIndex ) + Math.floor( this._.editor.config.basePopupZIndex / 2 ) );
		}
		CKEDITOR.dialog._.currentTop = this._.parentDialog;

		// Deduct or clear the z-index.
		if ( this._.parentDialog == null )
			CKEDITOR.dialog._.currentZIndex = null;
		else
			CKEDITOR.dialog._.currentZIndex -= 10;
	},

	addPage : function( contents, index )
	{
		var pageHtml = [],
			page,
			tab,
			titleHtml = contents.title ? 'title="' + CKEDITOR.tools.htmlEncode( contents.title ) + '" ' : '',
			elements = contents.elements;

		CKEDITOR.dialog._.uiElementBuilders.vbox.build( this,
				{
					type : 'vbox',
					className : 'cke_dialog_page_contents',
					children : contents.elements
				}, pageHtml );

		page = CKEDITOR.dom.element.createFromHtml( pageHtml.join( '' ) );
		tab = CKEDITOR.dom.element.createFromHtml( [
				'<span><div class="cke_dialog_tab" ', titleHtml, '>',
					'<div class="cke_dialog_tab_left"></div>',
					'<div class="cke_dialog_tab_center">',
						CKEDITOR.tools.htmlEncode( contents.label ),
					'</div>',
					'<div class="cke_dialog_tab_right"></div>',
				'</div></span>'
			].join( '' ) );
		this._.tabs[ contents.id ] = [ tab, page ];
		tab.getFirst().unselectable();
		page.appendTo( this._.parts.contents );
		tab.appendTo( this._.parts.tabs );
		tab.setAttribute( 'id', contents.id + '_' + CKEDITOR.tools.getNextNumber() );
		page.setAttribute( 'name', contents.id );
	},

	selectPage : function( id )
	{
		var bridge = this._.parts.bridge;

		// Hide the non-selected tabs and pages.
		for ( var i in this._.tabs )
		{
			var tab = this._.tabs[i][0],
				page = this._.tabs[i][1];
			if ( i != id )
			{
				tab.removeClass( 'cke_dialog_tab_selected' );
				page.hide();
			}
		}

		var selected = this._.tabs[id];
		selected[0].addClass( 'cke_dialog_tab_selected' );
		selected[1].show();

		// Place the bridge just under the selected tab. Count 1px left and right
		// of the tab as border space.
		setTimeout( function()
			{
				bridge.setStyles(
						{
							left : ( selected[0].getFirst().$.offsetLeft + 17 || 0 ) + 'px',
							width : ( selected[0].getFirst().$.offsetWidth - 2 || 0 ) + 'px'
						});
			}, 0 );
	},

	getElement : function()
	{
		return this._.element;
	},

	getChild : function( id )
	{
		return this._.contents[id];
	},

	getValueOf : function( id )
	{
		return this._.contents[id] && this._.contents[id].getValue();
	}
};

CKEDITOR.tools.extend( CKEDITOR.dialog,
	{
		add : function( name, callback )
		{
			this._.dialogDefinitions[name] = callback;
		},

		okButton : 
		{
			type : 'button',
			label : 'OK',
			style : 'width: 60px',
			onClick : function( evt )
			{
				var dialog = evt.data.dialog;
				if ( dialog.fire( 'ok', { hide : true } ).hide !== false )
					dialog.hide();
			}
		},

		cancelButton :
		{
			type : 'button',
			label : 'Cancel',
			style : 'width: 60px',
			onClick : function( evt )
			{
				var dialog = evt.data.dialog;
				if ( dialog.fire( 'cancel', { hide : true } ).hide !== false )
					dialog.hide();
			}
		},

		addUIElement : function( typeName, builder )
		{
			this._.uiElementBuilders[typeName] = builder;
		},

		storedDialogs : {},

		setMargins : function( top, right, bottom, left )
		{
			this._.margins = [ top, right, bottom, left ];
		}
	});

CKEDITOR.dialog._ = 
{
	defaultDialogDefinition :
	{
		resizable : CKEDITOR.DIALOG_RESIZE_NONE,
		minWidth : 600,
		minHeight : 400,
		buttons : [ CKEDITOR.dialog.okButton, CKEDITOR.dialog.cancelButton ]
	},

	uiElementBuilders : {},

	dialogDefinitions : {
		testOnly : function()
		{
			return {
				title : 'Test Dialog',
				resizable : CKEDITOR.DIALOG_RESIZE_NONE,
				minWidth : 500,
				minHeight : 400,
				contents : [
					{
						id : 'tab1',
						label : 'First Tab',
						title : 'First Tab Title',
						accessKey : 'Q',
						elements : [
							{
								type : 'text',
								label : 'Test Text 1',
								id : 'testText1',
								'default' : 'hello world!'
							},

							{
								type : 'text',
								label : 'Test Text 2',
								id : 'testText2',
								'default' : 'Wheee'
							},

							{
								type : 'text',
								label : 'Test Text 3',
								id : 'testText3',
								'default' : 'Blah blah'
							}
						]
					},

					{
						id : 'tab2',
						label : 'Second Tab',
						title : 'Second Tab Title',
						accessKey : 'W',
						elements : [
							{
								type : 'hbox',
								children : [
									{
										type : 'text',
										label : 'Test Text 4',
										title : 'Your love is like bad medicine!',
										id : 'testText4',
										'default' : 'hello world!',
										validate : function( dialog )
										{
											var valid = /^[A-Z a-z!]+$/.test( this.getValue() );
											if ( !valid )
											{
												this.select();
												alert( 'Test Text 4 must only contain alphanumeric characters, space, or ! and must not be empty.' );
											}
											return valid;
										}
									},

									{
										type : 'text',
										label : 'Test Text 5',
										id : 'testText5',
										'default' : 'Wheee'
									},

									{
										type : 'text',
										label : 'Test Text 6',
										id : 'testText6',
										'default' : 'Blah blah'
									}
								]
							}
						]
					},

					{
						id : 'tab3',
						label : 'Third Tab',
						title : 'Third Tab Title',
						accessKey : 'E',
						elements : [
							{
								type : 'vbox',
								children : [
									{
										type : 'checkbox',
										label : 'Enable this',
										title : 'Shake it up, just like bad medicine!',
										checked : false
									},

									{
										type : 'checkbox',
										label : 'Enable that',
										checked : true 
									},

									{
										type : 'checkbox',
										label : 'Enable those',
										checked : false
									},

									{
										type : 'radio',
										label : 'Include library:',
										title : 'Trying to include a library in LOLCODE.',
										'default' : 'stdio',
										items : [
											[ 'Standard I/O', 'stdio', 'You need this to write Hello World.' ],
											[ 'Standard C Library', 'stdlib', 'You need this to exit.' ],
											[ 'POSIX Library', 'unistd', 'You need this to sleep.' ],
											[ 'Signal Library', 'signal' ]
										]
									},

									{
										type : 'button',
										label : 'Click Me',
										title : 'Click me plz!',
										onClick : function( evt )
										{
											console.log( 'Clicked!!' );
										}
									},

									{
										type : 'html',
										html : '<strong>CKEditor rocks.</strong>'
									}
								]
							}
						]
					}
				]
			};
		}
	},

	addCover : function( editor )
	{
		var html = [
				'<div style="position: ', ( CKEDITOR.env.ie && CKEDITOR.env.version < 7 ? 'absolute' : 'fixed' ),
				'; z-index: ', editor.config.basePopupZIndex,
				'; top: 0px; left: 0px; ',
				'background-color: ', editor.config.backgroundCoverColor,
				'" id="cke_dialog_background_cover">'
			],
			win = CKEDITOR.document.getWindow();
		if ( CKEDITOR.env.ie && CKEDITOR.env.version < 7 )
		{
			html.push( '<iframe hidefocus="true" frameborder="0" name="cke_dialog_background_iframe" src="javascript: \'\'" ',
					'style="position: absolute; left: 0px; top: 0px; width: 100%; height: 100%; ',
					'progid:DXImageTransform.Microsoft.Alpha(opacity=0)" ></iframe>' );
		}
		html.push( '</div>' );
		var element = CKEDITOR.dom.element.createFromHtml( html.join( '' ) ),
			resizeFunc = function()
			{
				var size = win.getViewPaneSize();
				element.setStyles( 
						{
							width : size.width + 'px',
							height : size.height + 'px'
						});
			},
			scrollFunc = function()
			{
				var pos = win.getScrollPosition(),
					cursor = CKEDITOR.dialog._.currentTop;
				element.setStyles(
						{
							left : pos.x + 'px',
							top : pos.y + 'px'
						});

				do
				{
					var dialogPos = cursor.getPosition();
					cursor.move( dialogPos.x, dialogPos.y );
				} while( cursor = cursor._.parentDialog );
			};
		CKEDITOR.dialog._.resizeCover = resizeFunc;
		win.on( 'resize', resizeFunc );
		resizeFunc();
		if ( CKEDITOR.env.ie && CKEDITOR.env.version < 7 )
		{
			// IE BUG: win.$.onscroll assignment doesn't work.. it must be window.onscroll.
			// So we need to invent a really funny way to make it work.
			var myScrollHandler = function()
				{
					scrollFunc();
					arguments.callee.prevScrollHandler.apply( this, arguments );
				};
			win.$.setTimeout( function()
				{
					myScrollHandler.prevScrollHandler = window.onscroll || function(){};
					window.onscroll = myScrollHandler;
				}, 0 );
			scrollFunc();
		}
		element.setOpacity( editor.config.backgroundCoverOpacity );
		element.appendTo( CKEDITOR.document.getBody() );
	},

	removeCover : function()
	{
		var element = CKEDITOR.document.getById( 'cke_dialog_background_cover' ),
			win = CKEDITOR.document.getWindow();
		if ( element )
		{
			element.remove();
			win.removeListener( 'resize', CKEDITOR.dialog._.resizeCover );

			if ( CKEDITOR.env.ie && CKEDITOR.env.version < 7 )
			{
				win.$.setTimeout( function()
					{
						var prevScrollHandler = window.onscroll && window.onscroll.prevScrollHandler;
						window.onscroll = prevScrollHandler || null;
					}, 0 );
			}
			CKEDITOR.dialog._.resizeCover = null;
		}
	},

	initDragAndDrop : function( dialog )
	{
		var lastCoords = null,
			abstractDialogCoords = null,
			element = dialog.getElement().getFirst(),
			magnetDistance = dialog._.editor.config.magnetDistance,
			mouseMoveHandler = function( evt )
			{
				var dialogSize = dialog.getSize(),
					viewPaneSize = CKEDITOR.document.getWindow().getViewPaneSize(),
					x = evt.data.$.screenX,
					y = evt.data.$.screenY,
					dx = x - lastCoords.x,
					dy = y - lastCoords.y,
					realX, realY;

				lastCoords = { x : x, y : y };
				abstractDialogCoords.x += dx;
				abstractDialogCoords.y += dy;

				if ( abstractDialogCoords.x + CKEDITOR.dialog._.margins[3] < magnetDistance )
					realX = - CKEDITOR.dialog._.margins[3];
				else if ( abstractDialogCoords.x - CKEDITOR.dialog._.margins[1] > viewPaneSize.width - dialogSize.width - magnetDistance )
					realX = viewPaneSize.width - dialogSize.width + CKEDITOR.dialog._.margins[1];
				else
					realX = abstractDialogCoords.x;

				if ( abstractDialogCoords.y + CKEDITOR.dialog._.margins[0] < magnetDistance )
					realY = - CKEDITOR.dialog._.margins[0];
				else if ( abstractDialogCoords.y - CKEDITOR.dialog._.margins[2] > viewPaneSize.height - dialogSize.height - magnetDistance )
					realY = viewPaneSize.height - dialogSize.height + CKEDITOR.dialog._.margins[2];
				else
					realY = abstractDialogCoords.y;

				dialog.move( realX, realY );
			},
			mouseUpHandler = function( evt )
			{
				CKEDITOR.document.removeListener( 'mousemove', mouseMoveHandler );
				CKEDITOR.document.removeListener( 'mouseup', mouseUpHandler );

				if ( CKEDITOR.env.ie && CKEDITOR.env.version < 7 )
				{
					var coverDoc = new CKEDITOR.dom.document( frames( 'cke_dialog_background_iframe' ).document );
					coverDoc.removeListener( 'mousemove', mouseMoveHandler );
					coverDoc.removeListener( 'mouseup', mouseUpHandler );
				}
			};

		dialog._.parts.title.on( 'mousedown', function( evt )
				{
					lastCoords = { x : evt.data.$.screenX, y : evt.data.$.screenY };

					CKEDITOR.document.on( 'mousemove', mouseMoveHandler );
					CKEDITOR.document.on( 'mouseup', mouseUpHandler );
					abstractDialogCoords = dialog.getPosition();

					if ( CKEDITOR.env.ie && CKEDITOR.env.version < 7 )
					{
						var coverDoc = new CKEDITOR.dom.document( frames( 'cke_dialog_background_iframe' ).document );
						coverDoc.on( 'mousemove', mouseMoveHandler );
						coverDoc.on( 'mouseup', mouseUpHandler );
					}
				}, dialog );
	},

	initResizeHandles : function( dialog )
	{
		var minWidth = dialog._.definition.minWidth || 0,
			minHeight = dialog._.definition.minHeight || 0,
			topSizer = function( coords, dy )
			{
				coords.y += dy;
			},
			rightSizer = function( coords, dx )
			{
				coords.x2 += dx;
			},
			bottomSizer = function( coords, dy )
			{
				coords.y2 += dy;
			},
			leftSizer = function( coords, dx )
			{
				coords.x += dx;
			},
			lastCoords = null,
			abstractDialogCoords = null,
			magnetDistance = dialog._.editor.config.magnetDistance,
			parts = [ 'tl', 't', 'tr', 'l', 'r', 'bl', 'b', 'br' ],
			mouseDownHandler = function( evt )
			{
				var partName = evt.listenerData.part, size = dialog.getSize();
				abstractDialogCoords = dialog.getPosition();
				CKEDITOR.tools.extend( abstractDialogCoords, 
					{
						x2 : abstractDialogCoords.x + size.width,
						y2 : abstractDialogCoords.y + size.height
					} );
				lastCoords = { x : evt.data.$.screenX, y : evt.data.$.screenY };

				CKEDITOR.document.on( 'mousemove', mouseMoveHandler, dialog, { part : partName } );
				CKEDITOR.document.on( 'mouseup', mouseUpHandler, dialog, { part : partName } );

				if ( CKEDITOR.env.ie && CKEDITOR.env.version < 7 )
				{
					var coverDoc = new CKEDITOR.dom.document( frames( 'cke_dialog_background_iframe' ).document );
					coverDoc.on( 'mousemove', mouseMoveHandler, dialog, { part : partName } );
					coverDoc.on( 'mouseup', mouseUpHandler, dialog, { part : partName } );
				}
			},
			mouseMoveHandler = function( evt )
			{
				var x = evt.data.$.screenX,
					y = evt.data.$.screenY,
					dx = x - lastCoords.x,
					dy = y - lastCoords.y,
					viewPaneSize = CKEDITOR.document.getWindow().getViewPaneSize(),
					partName = evt.listenerData.part;

				if ( partName.search( 't' ) != -1 )
					topSizer( abstractDialogCoords, dy );
				if ( partName.search( 'l' ) != -1 )
					leftSizer( abstractDialogCoords, dx );
				if ( partName.search( 'b' ) != -1 )
					bottomSizer( abstractDialogCoords, dy );
				if ( partName.search( 'r' ) != -1 )
					rightSizer( abstractDialogCoords, dx );

				lastCoords = { x : x, y : y };

				var realX, realY, realX2, realY2;

				if ( abstractDialogCoords.x + CKEDITOR.dialog._.margins[3] < magnetDistance )
					realX = - CKEDITOR.dialog._.margins[3];
				else if ( partName.search( 'l' ) != -1 && abstractDialogCoords.x2 - abstractDialogCoords.x < minWidth + magnetDistance )
					realX = abstractDialogCoords.x2 - minWidth;
				else
					realX = abstractDialogCoords.x;

				if ( abstractDialogCoords.y + CKEDITOR.dialog._.margins[0] < magnetDistance )
					realY = - CKEDITOR.dialog._.margins[0];
				else if ( partName.search( 't' ) != -1 && abstractDialogCoords.y2 - abstractDialogCoords.y < minHeight + magnetDistance )
					realY = abstractDialogCoords.y2 - minHeight;
				else
					realY = abstractDialogCoords.y;

				if ( abstractDialogCoords.x2 - CKEDITOR.dialog._.margins[1] > viewPaneSize.width - magnetDistance )
					realX2 = viewPaneSize.width + CKEDITOR.dialog._.margins[1] ;
				else if ( partName.search( 'r' ) != -1 && abstractDialogCoords.x2 - abstractDialogCoords.x < minWidth + magnetDistance )
					realX2 = abstractDialogCoords.x + minWidth;
				else
					realX2 = abstractDialogCoords.x2;

				if ( abstractDialogCoords.y2 - CKEDITOR.dialog._.margins[2] > viewPaneSize.height - magnetDistance )
					realY2= viewPaneSize.height + CKEDITOR.dialog._.margins[2] ;
				else if ( partName.search( 'b' ) != -1 && abstractDialogCoords.y2 - abstractDialogCoords.y < minHeight + magnetDistance )
					realY2 = abstractDialogCoords.y + minHeight;
				else
					realY2 = abstractDialogCoords.y2 ;

				dialog.move( realX, realY );
				dialog.resize( realX2 - realX, realY2 - realY );
			},
			mouseUpHandler = function( evt )
			{
				CKEDITOR.document.removeListener( 'mouseup', mouseUpHandler );
				CKEDITOR.document.removeListener( 'mousemove', mouseMoveHandler );

				if ( CKEDITOR.env.ie && CKEDITOR.env.version < 7 )
				{
					var coverDoc = new CKEDITOR.dom.document( frames( 'cke_dialog_background_iframe' ).document );
					coverDoc.removeListener( 'mouseup', mouseUpHandler );
					coverDoc.removeListener( 'mousemove', mouseMoveHandler );
				}
			};

		for ( var i = 0 ; i < parts.length ; i++ )
		{
			var element = dialog._.parts[ parts[i] + '_resize' ];
			element.on( 'mousedown', mouseDownHandler, dialog, { part : parts[i] } );
		}
	},

	currentTop : null,

	currentZIndex : null,

	margins : [0, 0, 0, 0]
};

CKEDITOR.ui.dialog = 
{
	uiElement : function( dialog, elementDefinition, htmlList, nodeNameArg, stylesArg, attributesArg, contentsArg )
	{
		if (arguments.length < 4 )
			return;

		var nodeName = ( nodeNameArg.call ? nodeNameArg( elementDefinition ) : nodeNameArg ) || 'div',
			html = [ '<', nodeName, ' ' ],
			styles = ( stylesArg && stylesArg.call ? stylesArg( elementDefinition ) : stylesArg ) || {},
			attributes = ( attributesArg && attributesArg.call ? attributesArg( elementDefinition ) : attributesArg ) || {},
			innerHTML = ( contentsArg && contentsArg.call ? contentsArg( dialog, elementDefinition ) : contentsArg ) || '',
			id = this.id = attributes.id || elementDefinition.id || CKEDITOR.tools.getNextNumber() + '_uiElement',
			i;

		// Set the id, a unique id is required for getElement() to work.
		attributes.id = id;
		dialog._.contents[id] = this;

		// Set the type and definition CSS class names.
		var classes = {};
		if ( elementDefinition.type )
			classes[ 'cke_dialog_ui_' + elementDefinition.type ] = 1;
		if ( elementDefinition.className )
			classes[ elementDefinition.className ] = 1;
		var attributeClasses = ( attributes['class'] && attributes['class'].split ) ? attributes['class'].split( ' ' ) : [];
		for ( i = 0 ; i < attributeClasses.length ; i++ )
		{
			if ( attributeClasses[i] )
				classes[ attributeClasses[i] ] = 1;
		}
		var finalClasses = [];
		for ( i in classes )
			finalClasses.push( i );
		attributes['class'] = finalClasses.join( ' ' );

		// Set the popup tooltop.
		if ( elementDefinition.title )
			attributes.title = elementDefinition.title;

		// Write the inline CSS styles.
		var styleStr = ( elementDefinition.style || '' ).split( ';' );
		for ( i in styles )
			styleStr.push( i + ':' + styles[i] );
		for ( i = styleStr.length - 1 ; i >= 0 ; i-- )
		{
			if ( styleStr[i] === '' )
				styleStr.splice( i, 1 );
		}
		if ( styleStr.length > 0 )
			attributes.style = ( attributes.style || '' ) + styleStr.join( '; ' );

		// Write the attributes.
		for ( i in attributes )
			html.push( i + '="' + CKEDITOR.tools.htmlEncode( attributes[i] ) + '" ');

		// Write the content HTML.
		html.push( '>', innerHTML, '</', nodeName, '>' );

		// Add contents to the parent HTML array.
		htmlList.push( html.join( '' ) );

		// Add the onLoad event to dialog.
		if ( elementDefinition.onLoad )
			dialog.on( 'load', elementDefinition.onLoad, this, null, CKEDITOR.tools.getNextNumber() );

		( this._ || ( this._ = {} ) ).dialog = dialog;
	},

	hbox : function( dialog, childObjList, childHtmlList, htmlList, elementDefinition )
	{
		if ( arguments.length < 4 )
			return;

		if ( !this._ )
			this._ = {};

		var children = this._.children = childObjList,
			widths = elementDefinition && elementDefinition.widths || null,
			height = elementDefinition && elementDefinition.height || null,
			i;
		var innerHTML = function()
		{
			var html = [ '<tbody><tr class="cke_dialog_ui_hbox">' ];
			for ( i = 0 ; i < childHtmlList.length ; i++ )
			{
				var className = 'cke_dialog_ui_hbox_child',
					styles = [];
				if ( i === 0 )
					className = 'cke_dialog_ui_hbox_first';
				if ( i == childHtmlList.length - 1 )
					className = 'cke_dialog_ui_hbox_last';
				html.push( '<td class="', className, '" ' );
				if ( widths )
				{
					if ( widths[i] && isFinite( parseFloat( widths[i] ) ) )
						styles.push( 'width:' + widths[i] + 'px' );
				}
				else
					styles.push( 'width:' + Math.floor( 100 / childHtmlList.length ) + '%' );
				if ( height && isFinite( parseFloat( height ) ) )
					styles.push( 'height:' + height + 'px' );
				if ( styles.length > 0 )
					html.push( 'style="' + styles.join('; ') + '" ' );
				html.push( '>', childHtmlList[i], '</td>' );
			}
			html.push( '</tr></tbody>' );
			return html.join( '' );
		};
		CKEDITOR.ui.dialog.uiElement.call( this, dialog, elementDefinition || { type : 'hbox' }, htmlList, 'table', null, null, innerHTML );
	},

	vbox : function( dialog, childObjList, childHtmlList, htmlList, elementDefinition )
	{
		if (arguments.length < 3 )
			return;

		if ( !this._ )
			this._ = {};

		var children = this._.children = childObjList,
			width = elementDefinition && elementDefinition.width || null,
			heights = elementDefinition && elementDefinition.heights || null;
		var innerHTML = function()
		{
			var html = [];
			for ( var i = 0 ; i < childHtmlList.length ; i++ )
			{
				var styles = [];
				html.push( '<div ' );
				if ( width && isFinite( parseFloat( width ) ) )
					styles.push( 'width:' + width + 'px' );
				if ( heights && isFinite( parseFloat( heights[i] ) ) )
					styles.push( 'height:' + heights[i] + 'px' );
				if ( styles.length > 0 )
					html.push( 'style="', styles.join( '; ' ), '" ' );
				html.push( ' class="cke_dialog_ui_vbox_child">', childHtmlList[i], '</div>' );
			}
			return html.join( '' );
		};
		CKEDITOR.ui.dialog.uiElement.call( this, dialog, elementDefinition || { type : 'vbox' }, htmlList, 'div', null, null, innerHTML );
	}
};

CKEDITOR.ui.dialog.uiElement.prototype = 
{
	getElement: function()
	{
		return CKEDITOR.document.getById( this.id );
	},

	setValue : function( value )
	{
		this.getElement().$.value = value;
	},

	getValue : function()
	{
		return this.getElement().$.value;
	},

	isChanged : function()
	{
		// Override in input classes.
		return false;
	},

	focus : function()
	{
		var element = this.getElement(),
			cursor = element,
			tabId;
		while ( ( cursor = cursor.getParent() ) && cursor.$.className.search( 'cke_dialog_page_contents' ) == -1 );
		tabId = cursor.getAttribute( 'name' );

		this._.dialog.selectPage( tabId );
		element.focus();
	}
};

CKEDITOR.ui.dialog.hbox.prototype = CKEDITOR.tools.extend( new CKEDITOR.ui.dialog.uiElement,
	{
		getChild : function( indices )
		{
			if ( !indices.splice )
				indices = [ indices ];
			if ( indices.length < 2 )
				return this._.children[ indices[0] ];
			else
				return ( this._.children[ indices[0] ] && this._.children[ indices[0] ].getChild ) ?
					this._.children[ indices[0] ].getChild( indices.slice( 1, indices.length ) ) :
					null;
		}
	}, true );

CKEDITOR.ui.dialog.vbox.prototype = CKEDITOR.ui.dialog.hbox.prototype;

CKEDITOR.tools.extend( CKEDITOR.editor.prototype,
	{
		openDialog : function( dialogName )
		{
			var dialog = CKEDITOR.dialog.storedDialogs[dialogName] || new CKEDITOR.dialog( this, dialogName );
			CKEDITOR.dialog.storedDialogs[dialogName] = dialog;
			dialog.show();
			return dialog;
		}
	});

(function()
{
	var commonBuilder = {
		build : function( dialog, elementDefinition, output )
		{
			var children = elementDefinition.children,
				child,
				childHtmlList = [],
				childObjList = [];
			for ( var i = 0 ; ( i < children.length && ( child = children[i] ) ) ; i++ )
			{
				var childHtml = [];
				childHtmlList.push( childHtml );
				childObjList.push( CKEDITOR.dialog._.uiElementBuilders[ child.type ].build( dialog, child, childHtml ) );
			}
			return new CKEDITOR.ui.dialog[elementDefinition.type]( dialog, childObjList, childHtmlList, output, elementDefinition );
		}
	};

	CKEDITOR.dialog.addUIElement( 'hbox', commonBuilder );
	CKEDITOR.dialog.addUIElement( 'vbox', commonBuilder );
})();
