﻿/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

/**
 * @fileOverview Defines the {@link CKEDITOR.test} object, which contains
 *		functions used at our testing environment.
 */

/*jsl:import ../tests/yuitest.js*/

/**
 * Contains functions used at our testing environment. Currently,
 * our testing system is based on the
 * <a href="http://developer.yahoo.com/yui/yuitest/">YUI Test</a>.
 * @namespace
 * @example
 */
CKEDITOR.test =
{
	/**
	 * The assertion namespace, containing all assertion functions. Currently,
	 * this is an alias for
	 * <a href="http://developer.yahoo.com/yui/docs/YAHOO.util.Assert.html">YAHOO.util.Assert</a>.
	 * @example
	 * <b>CKEDITOR.test.assert</b>.areEqual( '10', 10 );        // "true"
	 * <b>CKEDITOR.test.assert</b>.areSame( '10', 10 );         // "false"
	 * <b>CKEDITOR.test.assert</b>.isUndefined( window.test );  // "true"
	 */
	assert : YAHOO.util.Assert,

	/**
	 * Adds a test case to the test runner.
	 * @param {Object} testCase The test case object. See other tests for
	 *		examples.
	 * @example
	 * <b>CKEDITOR.test.addTestCase</b>((function()
	 * {
	 *     // Local reference to the "assert" object.
	 *     var assert = CKEDITOR.test.assert;
	 *
	 *     return {
	 *         test_example : function()
	 *         {
	 *             assert.areSame( '10', 10 );  // FAIL
	 *         }
	 *      };
	 * })());
	 */
	addTestCase : function( testCase )
	{
		YAHOO.tool.TestRunner.add( new YAHOO.tool.TestCase( testCase ) );
	},
	
	/**
	 * Gets the inner HTML of an element, for testing purposes.
	 */
	getInnerHtml : function( elementOrId )
	{
		var html = ( elementOrId.nodeType ? elementOrId : document.getElementById( elementOrId ) ).innerHTML;
		html = html.toLowerCase();
		html = html.replace( /["\n\r]/g, '' );
		html = html.replace( /\s+_cke_expando=\d+/g, '' );
		return html;
	}
};
