/*
 * FCKeditor - The text editor for Internet - http://www.fckeditor.net
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 * 
 * == BEGIN LICENSE ==
 * 
 * Licensed under the terms of any of the following licenses at your
 * choice:
 * 
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 * 
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 * 
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 * 
 * == END LICENSE ==
 */
package net.fckeditor.connector;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import net.fckeditor.requestcycle.ThreadLocalData;
import net.fckeditor.requestcycle.impl.ServerRootPathBuilder;

/**
 * This is the FCKeditor Connector servlet. It has the following jobs:
 * <ul>
 * <li>Initialization of the {@link Dispatcher} object.</li>
 * <li>Calling {@link ThreadLocalData#beginRequest(HttpServletRequest)}
 * (It is an object that holds request-based objects.)</li>
 * <li>Forwarding the requests:
 * 	<ul><li><code>GET</code> to {@link Dispatcher#doGet(HttpServletRequest, HttpServletResponse)} </li>
 * 		<li><code>POST</code> to {@link Dispatcher#doPost(HttpServletRequest, HttpServletResponse)}.</li>
 *  </ul></li>
 * <li>Calling {@link ThreadLocalData#endRequest()} to cleanup all ThreadLocal
 * objects independent of if an exception was thrown or not. That's very
 * important to prevent memory-leaks!!!</li>
 * </ul><br>
 * Summing up: This workflow guarantees the correct initialization and cleaning
 * of the {@link ThreadLocalData}, - it's essential because of preventing memory-leaks. 
 * All requests are dispatched to the {@link Dispatcher}. The {@link Dispatcher} 
 * forwards the request to an implementation of the {@link Connector}.
 * 
 * @version $Id: ConnectorServlet.java 2627 2008-11-05 16:49:59Z mosipov $
 */
public class ConnectorServlet extends HttpServlet {
	private static final long serialVersionUID = -5742008970929377161L;
	private Dispatcher dispatcher;
	
	/**
	 * Initializes the {@link Dispatcher}.
	 * 
	 * @see javax.servlet.GenericServlet#init()
	 */
	@Override
	public void init() throws ServletException {
		try {
			dispatcher = new Dispatcher(getServletContext());
		} catch (Exception e) {
			throw new ServletException(e);
		}
	}
	
	/* (non-Javadoc)
	 * @see javax.servlet.http.HttpServlet#doGet(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	@Override
	protected void doGet(final HttpServletRequest request, final HttpServletResponse response)
			throws ServletException, IOException {
		try {
			ThreadLocalData.beginRequest(request);
			dispatcher.doGet(request, response);
		} catch (Exception e) {
			// if an exception wasn't catched by the Dispatcher, it is a fatal
			// one and has to re-thrown.
			if (e instanceof IOException)
				throw (IOException) e;
			else
				throw new ServletException(e);
		} finally {
			ThreadLocalData.endRequest();
		}		
	}

	/* (non-Javadoc)
	 * @see javax.servlet.http.HttpServlet#doPost(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	@Override
	protected void doPost(final HttpServletRequest request, final HttpServletResponse response)
			throws ServletException, IOException {
		try {
			ThreadLocalData.beginRequest(request);
			dispatcher.doPost(request, response);
		} catch (Exception e) {
			// if an exception wasn't catched by the Dispatcher, it is a fatal
			// one and has to re-thrown.
			if (e instanceof IOException)
				throw (IOException) e;
			else
				throw new ServletException(e);
		} finally {
			ThreadLocalData.endRequest();
		}
	}

}
