/*
 * FCKeditor - The text editor for Internet - http://www.fckeditor.net
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 * 
 * == BEGIN LICENSE ==
 * 
 * Licensed under the terms of any of the following licenses at your
 * choice:
 * 
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 * 
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 * 
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 * 
 * == END LICENSE ==
 */
package net.fckeditor.handlers;

import net.fckeditor.connector.Connector;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Handler for Connector-related properties.<br />
 * Wraps to the {@link PropertiesLoader}.
 * TODO improve documentation of the property key mapping
 * 
 * @version $Id: ConnectorHandler.java 2627 2008-11-05 16:49:59Z mosipov $
 */
public class ConnectorHandler {
	
	private static Logger logger = LoggerFactory.getLogger(ConnectorHandler.class);
	private static Connector connector = null;
	
	static {
		
		// try to instantiate the Connector object
		String fqcn = PropertiesLoader.getProperty("connector.impl");
		if (fqcn == null)
			logger.warn("No property found for Connector implementation, any user action will be disabled!");
		else {
			try {
				Class<?> clazz = Class.forName(fqcn);
				connector = (Connector) clazz.newInstance();
				logger.info("Connector initialized to {}", connector.getClass());
			} catch (Exception e) {
				logger.error("Couldn't instantiate class [".concat(fqcn).concat(
				        "], any user action will disabled!"), e);
			}
		}
	}

	/**
	 * Getter for the <code>UserFilesPath</code>.
	 * 
	 * @return UserFilePath
	 */
	public static String getUserFilesPath() {
		return PropertiesLoader.getProperty("connector.userFilesPath");
    }
	
	/**
	 * Getter for the <code>UserFilesAbsolutePath</code>.
	 * 
	 * @return UserFilesAbsolutePath
	 */
	public static String getUserFilesAbsolutePath() {
		return PropertiesLoader.getProperty("connector.userFilesAbsolutePath");
    }

	/**
	 * Getter for the default handling of files with multiple extensions.
	 * 
	 * @return <code>true</code> if single extension only should be enforced
	 *         else <code>false</code>.
	 */
	public static boolean isForceSingleExtension() {
		return Boolean.valueOf(PropertiesLoader.getProperty("connector.forceSingleExtension"));
	}

	/**
	 * Getter for the value to instruct the Connector to check if the uploaded
	 * image is really an image.
	 * 
	 * @return Boolean value of the property
	 *         <code>connector.secureImageUploads</code>.
	 */
	public static boolean isSecureImageUploads() {
		return Boolean.valueOf(PropertiesLoader.getProperty("connector.secureImageUploads"));
	}

	/**
	 * Getter for the implementation of {@link Connector}.
	 * 
	 * @return Implementation of {@link Connector}.
	 */
	public static Connector getConnector() {
		return connector;
	}
}
