/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

CKEDITOR.plugins.add( 'smiley',
{
	init : function( editor, pluginPath )
	{
		var smiley = CKEDITOR.plugins.smiley;

		editor.addCommand( 'smiley', smiley.commands.smiley );
		editor.ui.addButton( 'Smiley',
			{
				label : editor.lang.smiley,
				command : 'smiley'
			});
		CKEDITOR.dialog.add( 'smiley', smiley.dialog );
	},

	lang : [ 'en' ]
} );

CKEDITOR.plugins.smiley =
{
	commands : 
	{
		smiley :
		{
			exec : function( editor )
			{
				editor.openDialog( 'smiley' );
			}
		}
	},

	dialog : function( editor )
	{
		var smileySelector =
		{
			type : 'html',
			onClick : function( evt )
			{
				var target = evt.data.getTarget(),
					targetName = target.getName();
				if ( targetName != 'td' && targetName != 'img' )
					return;

				if ( targetName == 'td' )
					target = target.getChild(0).$;
				else
					target = target.$;

				this.getDialog().restoreSelection();
				editor.insertElement( CKEDITOR.dom.element.createFromHtml( '<img src="' + CKEDITOR.tools.htmlEncode( target.src ) + '" />',
					editor.document ) );
				this.getDialog().hide();
				editor.focus();
			},
			style : 'width: 100%; height: 100%; border-collapse: separate;'
		},
			html = [ '<table cellspacing="2" cellpadding="2" border="0"><tbody>' ],
			cellWidth = parseInt( 100 / editor.config.smileyColumns ) + '%',
			images = editor.config.smileyImages,
			columns = editor.config.smileyColumns,
			i;

		for ( i = 0 ; i < images.length ; i++ )
		{
			if ( i % editor.config.smileyColumns == 0 )
				html.push( '<tr>' );

			html.push( '<td class="dark_background hand centered" style="vertical-align: middle;"><img border="0" src="' + 
					CKEDITOR.tools.htmlEncode( editor.config.smileyPath + images[i] ) + '" ' +
					// IE BUG: Below is a workaround to an IE image loading bug to ensure the image sizes are correct.
					( CKEDITOR.env.ie ? 'onload="this.setAttribute(\'width\', 2); this.removeAttribute(\'width\');" ' : '' ) + 
					'class="hand" /></td>' );

			if ( i % columns == columns - 1 )
				html.push( '</tr>' );
		}

		if ( i < columns - 1 )
		{
			for ( ; i < columns - 1 ; i++ )
				html.push( '<td></td>' );
			html.push( '</tr>' );
		}

		html.push( '</tbody></table>' );
		smileySelector.html = html.join( '' );

		return {
			title : editor.lang.smileyTitle,
			minWidth : editor.config.smileyWindowWidth,
			minHeight : editor.config.smileyWindowHeight,
			contents : [
				{
					id : 'tab1',
					label : '',
					title : '',
					expand : true,
					elements : [
							smileySelector
						]
				}
			],
			buttons : [ CKEDITOR.dialog.cancelButton ]
		};
	}
};
