﻿/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

CKEDITOR.dom.documentFragment = function( ownerDocument )
{
	this.$ = CKEDITOR.env.ie ? ownerDocument.$.createElement( 'div' ) : ownerDocument.$.createDocumentFragment();
};

(function()
{
	var elementPrototype = CKEDITOR.dom.element.prototype;

	CKEDITOR.dom.documentFragment.prototype =
	{
		type : CKEDITOR.NODE_DOCUMENT_FRAGMENT,

		append : elementPrototype.append,

		appendTo : function( targetElement )
		{
			if ( CKEDITOR.env.ie )
				elementPrototype.moveChildren.call( this, targetElement );
			else
				targetElement.$.appendChild( this.$ );
		},

		insertAfterNode : function( node )
		{
			var $ = this.$;
			var $node = node.$;
			var $parent = $node.parentNode;

			if ( CKEDITOR.env.ie )
			{
				for ( var child ; child = $.lastChild ; )
					$parent.insertBefore( $.removeChild( child ), $node.nextSibling );
			}
			else
				$parent.insertBefore( $, $node.nextSibling );
		}
	};
})();
