/*
 * FCKeditor - The text editor for Internet - http://www.fckeditor.net
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 * 
 * == BEGIN LICENSE ==
 * 
 * Licensed under the terms of any of the following licenses at your
 * choice:
 * 
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 * 
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 * 
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 * 
 * == END LICENSE ==
 */
package net.fckeditor.tags;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;

import net.fckeditor.handlers.LocalizedProperties;
import net.fckeditor.handlers.RequestCycleHandler;
import net.fckeditor.tool.Compatibility;

/**
 * This tag displays information about browser and user capabilities. There are
 * four available commands (CompatibleBrowser, FileBrowsing, FileUpload,
 * FolderCreation) which respond the ability status as a localized message, if
 * provided.
 * 
 * @version $Id: CheckTag.java 2659 2008-11-12 20:04:25Z mosipov $
 */
public class CheckTag extends TagSupport {

	private static final long serialVersionUID = -6834095891675681686L;

	private static final String FILE_UPLOAD = "FileUpload";
	private static final String FILE_BROWSING = "FileBrowsing";
	private static final String FOLDER_CREATION = "FolderCreation";
	private static final String COMPATIBLE_BROWSER = "CompatibleBrowser";
	private static Set<String> commands = new HashSet<String>(4);

	static {
		commands.add(FILE_UPLOAD);
		commands.add(FILE_BROWSING);
		commands.add(FOLDER_CREATION);
		commands.add(COMPATIBLE_BROWSER);
	}

	private String command;

	/**
	 * Sets the desired command.
	 * 
	 * @param command
	 * @throws JspTagException
	 */
	public void setCommand(String command) throws JspTagException {
		if (!commands.contains(command))
			throw new JspTagException(
					"You have to provide one of the following commands: "
							+ commands);
		this.command = command;
	}

	@Override
	public int doStartTag() throws JspException {
		JspWriter out = pageContext.getOut();

		HttpServletRequest request = (HttpServletRequest) pageContext
				.getRequest();
		LocalizedProperties lp = LocalizedProperties
				.getInstance(request);
		String response = null;

		if (command.equals(FILE_UPLOAD)) {
			if (RequestCycleHandler.isEnabledForFileUpload(request))
				response = lp.getFileUploadEnabled();
			else
				response = lp.getFileUploadDisabled();
		}

		if (command.equals(FILE_BROWSING)) {
			if (RequestCycleHandler.isEnabledForFileBrowsing(request))
				response = lp.getFileBrowsingEnabled();
			else
				response = lp.getFileBrowsingDisabled();
		}

		if (command.equals(FOLDER_CREATION)) {
			if (RequestCycleHandler.isEnabledForFolderCreation(request))
				response = lp.getFolderCreationEnabled();
			else
				response = lp.getFolderCreationDisabled();
		}

		if (command.equals(COMPATIBLE_BROWSER)) {
			if (Compatibility.isCompatibleBrowser(request))
				response = lp.getCompatibleBrowser();
			else
				response = lp.getNotCompatibleBrowser();
		}

		try {
			out.print(response);
		} catch (IOException e) {
			throw new JspException(
					"Tag response could not be written to the user!", e);
		}

		return SKIP_BODY;
	}

}
