/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */
CKEDITOR.dialog.add( 'button', function( editor )
{
	return {
		title : editor.lang.buttonProp,
		resizable : CKEDITOR.DIALOG_RESIZE_NONE,
		minWidth : 400,
		minHeight : 230,
		onOk: function( data ) {
			return true;
		},

		onCancel: function() {
		},
		
		onLoad: function( data ) {
			return true;
		},
		contents : [
			{
				id : 'info',
				label : editor.lang.buttonProp,
				title : editor.lang.buttonProp,
				accessKey : 'I',
				elements : [
					{
						id : 'txtName',
						type : 'text',
						label : editor.lang.dlgCheckboxName,
						'default' : '',
						validate: function( data ) {
							return true;
						}
					},
					{
						id : 'txtValue',
						type : 'text',
						label : editor.lang.dlgButtonText,
						accessKey : 'V',
						validate: function( data ) {
							return true;
						}
					},
					{
						id : 'txtType',
						type : 'select',
						label : editor.lang.dlgButtonType,
						'default' : 'url',
						accessKey : 'T',
						items :
						[
							[ editor.lang.dlgButtonTypeBtn, 'button' ],
							[ editor.lang.dlgButtonTypeSbm, 'submit' ],
							[ editor.lang.dlgButtonTypeRst, 'reset' ]
						],
						validate: function( data ) {
							return true;
						}
					}
				]
			}
		]
	};
});
