/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */
CKEDITOR.dialog.add( 'form', function( editor )
{
	return {
		title : editor.lang.formProp,
		resizable : CKEDITOR.DIALOG_RESIZE_NONE,
		minWidth : 400,
		minHeight : 230,
		onOk: function( data ) {
			return true;
		},

		onCancel: function() {
		},
		
		onLoad: function( data ) {
			return true;
		},
		contents : [
			{
				id : 'info',
				label : editor.lang.formProp,
				title : editor.lang.formProp,
				accessKey : 'I',
				elements : [
					{
						id : 'txtName',
						type : 'text',
						label : editor.lang.dlgFormName,
						'default' : '',
						accessKey : 'N',
						validate: function( data ) {
							return true;
						}
					},
					{
						id : 'txtAction',
						type : 'text',
						label : editor.lang.dlgFormAction,
						'default' : '',
						accessKey : 'A',
						validate: function( data ) {
							return true;
						}
					},
					{
						id : 'txtMethod',
						type : 'select',
						label : editor.lang.dlgFormMethod,
						'default' : 'url',
						accessKey : 'M',
						items :
						[
							[ editor.lang.url, 'url' ],
							[ editor.lang.linkToAnchor, 'anchor' ],
							[ editor.lang.linkToEmail, 'email' ]
						],
						validate: function( data ) {
							return true;
						}
					}
				]
			}
		]
	};
});
