/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */
CKEDITOR.dialog.add( 'radio', function( editor )
{
	return {
		title : editor.lang.radioButtonProp,
		resizable : CKEDITOR.DIALOG_RESIZE_NONE,
		minWidth : 400,
		minHeight : 200,
		onOk: function( data ) {
			return true;
		},

		onCancel: function() {
		},
		
		onLoad: function( data ) {
			return true;
		},
		contents : [
			{
				id : 'info',
				label : editor.lang.radioButtonProp,
				title : editor.lang.radioButtonProp,
				accessKey : 'I',
				elements : [
					{
						id : 'txtName',
						type : 'text',
						label : editor.lang.dlgCheckboxName,
						'default' : '',
						accessKey : 'N',
						validate: function( data ) {
							return true;
						}
					},
					{
						id : 'txtValue',
						type : 'text',
						label : editor.lang.dlgCheckboxValue,
						'default' : '',
						accessKey : 'V',
						validate: function( data ) {
							return true;
						}
					},
					{
						id : 'txtSelected',
						type : 'checkbox',
						label : editor.lang.dlgCheckboxSelected,
						'default' : 'url',
						accessKey : 'S',
						validate: function( data ) {
							return true;
						}
					}
				]
			}
		]
	};
});
