/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

CKEDITOR.plugins.add( 'forms',
{
	init : function( editor, pluginPath )
	{
		var forms = CKEDITOR.plugins.forms;
		editor.ui.addButton( 'Form',
			{
				label : editor.lang.form,
				command : 'form'
			});
		editor.addCommand( 'form', forms.commands.form );

		editor.ui.addButton( 'Checkbox',
			{
				label : editor.lang.checkbox,
				command : 'checkbox'
			});
		editor.addCommand( 'checkbox', forms.commands.checkbox );

		editor.ui.addButton( 'Radio',
			{
				label : editor.lang.radio,
				command : 'radio'
			});
		editor.addCommand( 'radio', forms.commands.radio );

		editor.ui.addButton( 'TextField',
			{
				label : editor.lang.textField,
				command : 'textfield'
			});
		editor.addCommand( 'textfield', forms.commands.textfield );

		editor.ui.addButton( 'Select',
			{
				label : editor.lang.select,
				command : 'select'
			});
		editor.addCommand( 'select', forms.commands.select );

		editor.ui.addButton( 'Button',
			{
				label : editor.lang.button,
				command : 'button'
			});
		editor.addCommand( 'button', forms.commands.button );

		editor.ui.addButton( 'ImageButton',
			{
				label : editor.lang.imageButton,
				command : 'imagebutton'
			});
		editor.addCommand( 'imagebutton', forms.commands.imagebutton );

		editor.ui.addButton( 'HiddenField',
			{
				label : editor.lang.hiddenField,
				command : 'hiddenfield'
			});
		editor.addCommand( 'hiddenfield', forms.commands.hiddenfield );

		CKEDITOR.dialog.add( 'form',		'_source/dialogs/form.js' );
		CKEDITOR.dialog.add( 'checkbox',	'_source/dialogs/checkbox.js' );
		CKEDITOR.dialog.add( 'radio', 		'_source/dialogs/radio.js' );
		CKEDITOR.dialog.add( 'textfield',	'_source/dialogs/textfield.js' );
		CKEDITOR.dialog.add( 'select',		'_source/dialogs/select.js' );
		CKEDITOR.dialog.add( 'button',		'_source/dialogs/button.js' );
		CKEDITOR.dialog.add( 'imagebutton',	'_source/dialogs/image.js' );
		CKEDITOR.dialog.add( 'hiddenfield',	'_source/dialogs/hiddenfield.js' );
	}
} );

CKEDITOR.plugins.forms =
{
	commands : 
	{
		form :
		{
			exec : function( editor )
			{
				editor.openDialog( 'form' );
			}
		},
		checkbox :
		{
			exec : function( editor )
			{
				editor.openDialog( 'checkbox' );
			}
		},
		radio :
		{
			exec : function( editor )
			{
				editor.openDialog( 'radio' );
			}
		},
		textfield :
		{
			exec : function( editor )
			{
				editor.openDialog( 'textfield' );
			}
		},
		select :
		{
			exec : function( editor )
			{
				editor.openDialog( 'select' );
			}
		},
		button :
		{
			exec : function( editor )
			{
				editor.openDialog( 'button' );
			}
		},
		imagebutton :
		{
			exec : function( editor )
			{
				editor.openDialog( 'imagebutton' );
			}
		},
		hiddenfield :
		{
			exec : function( editor )
			{
				editor.openDialog( 'hiddenfield' );
			}
		},
	},
};
