/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

CKEDITOR.plugins.add( 'link',
{
	init : function( editor, pluginPath )
	{
		editor.addCommand( 'link', new CKEDITOR.dialogCommand( 'link' ) );
		editor.ui.addButton( 'Link',
			{
				label : editor.lang.link,
				command : 'link'
			} );
		CKEDITOR.dialog.add( 'link', CKEDITOR.plugins.link.dialog );
	}
} );

CKEDITOR.plugins.link =
{
	dialog : function( editor )
	{
		return {
			title : editor.lang.linkTitle,
			minWidth : 400,
			minHeight : 320,
			contents : [
				{
					id : 'info',
					label : editor.lang.linkInfo,
					elements :
					[
						{
							id : 'linkType',
							type : 'select',
							label : editor.lang.linkType,
							'default' : 'url',
							items :
							[
								[ editor.lang.url, 'url' ],
								[ editor.lang.linkToAnchor, 'anchor' ],
								[ editor.lang.linkToEmail, 'email' ]
							]
						},
						{
							type : 'hbox',
							widths : [ '25%', '75%' ],
							children : 
							[
								{
									id : 'protocol',
									type : 'select',
									label : editor.lang.protocol,
									'default' : 'http://',
									style : 'width : 100%;',
									items :
									[
										[ 'http://' ],
										[ 'https//' ],
										[ 'ftp://' ],
										[ 'news://' ],
										[ '<other>' ]
									]
								},
								{
									type : 'text',
									id : 'url',
									label : editor.lang.url
								}
							]
						},
						{
							type : 'button',
							id : 'browse',
							label : editor.lang.browseServer
						}
					]
				},
				{
					id : 'target',
					label : editor.lang.linkTarget,
					elements : 
					[
						{
							type : 'hbox',
							widths : [ '50%', '50%' ],
							children :
							[
								{
									type : 'select',
									id : 'linkTargetType',
									label : editor.lang.linkTarget,
									'default' : 'notSet',
									style : 'width : 100%;',
									'items' : 
									[
										[ editor.lang.linkTargetNotSet, 'notSet' ],
										[ editor.lang.linkTargetFrame, 'frame' ],
										[ editor.lang.linkTargetPopup, 'popup' ],
										[ editor.lang.linkTargetNew, 'new' ],
										[ editor.lang.linkTargetType, 'top' ],
										[ editor.lang.linkTargetSelf, 'self' ],
										[ editor.lang.linkTargetParent, 'parent' ]
									]
								},
								{
									type : 'text',
									id : 'linkTargetName',
									label : editor.lang.linkTargetFrameName
								}
							]
						},
						{
							type : 'vbox',
							width : 260,
							align : 'center',
							padding : 2,
							children : 
							[
								{
									type : 'html',
									html : '<div>' + CKEDITOR.tools.htmlEncode( editor.lang.linkPopupFeatures ) + '</div>'
								},
								{
									type : 'hbox',
									children : 
									[
										{
											type : 'checkbox',
											id : 'resizable',
											label : editor.lang.linkPopupResizable
										},
										{
											type : 'checkbox',
											id : 'statusBar',
											label : editor.lang.linkPopupStatusBar
										}
									]
								},
								{
									type : 'hbox',
									children :
									[
										{
											type : 'checkbox',
											id : 'locationBar',
											label : editor.lang.linkPopupLocationBar
										},
										{
											type : 'checkbox',
											id : 'toolbar',
											label : editor.lang.linkPopupToolbar
										}
									]
								},
								{
									type : 'hbox',
									children :
									[
										{
											type : 'checkbox',
											id : 'menubar',
											label : editor.lang.linkPopupMenuBar
										},
										{
											type : 'checkbox',
											id : 'fullscreen',
											label : editor.lang.linkPopupFullScreen
										}
									]
								},
								{
									type : 'hbox',
									children :
									[
										{
											type : 'checkbox',
											id : 'scrollbars',
											label : editor.lang.linkPopupScrollBars
										},
										{
											type : 'checkbox',
											id : 'dependent',
											label : editor.lang.linkPopupDependent
										}
									]
								},
								{
									type : 'hbox',
									children :
									[
										{
											type : 'hbox',
											padding : 0,
											widths : [ '30%', '70%' ],
											children : 
											[
												{
													'type' : 'html',
													html : '<span>' + CKEDITOR.tools.htmlEncode( editor.lang.linkPopupWidth ) + '</span>'
												},
												{
													'type' : 'text',
													labelLayout : 'horizontal',
													label : '',
													id : 'popupWidth'
												}
											]
										},
										{
											type : 'hbox',
											padding : 0,
											widths : [ '55%', '45%' ],
											children : 
											[
												{
													'type' : 'html',
													html : '<span>' + CKEDITOR.tools.htmlEncode( editor.lang.linkPopupLeft ) + '</span>'
												},
												{
													'type' : 'text',
													labelLayout : 'horizontal',
													label : '',
													id : 'popupLeft'
												}
											]
										}
									]
								},
								{
									type : 'hbox',
									children :
									[
										{
											type : 'hbox',
											padding : 0,
											widths : [ '30%', '70%' ],
											children : 
											[
												{
													'type' : 'html',
													html : '<span>' + CKEDITOR.tools.htmlEncode( editor.lang.linkPopupHeight ) + '</span>'
												},
												{
													'type' : 'text',
													labelLayout : 'horizontal',
													label : '',
													id : 'popupHeight'
												}
											]
										},
										{
											type : 'hbox',
											padding : 0,
											widths : [ '55%', '45%' ],
											children : 
											[
												{
													'type' : 'html',
													html : '<span>' + CKEDITOR.tools.htmlEncode( editor.lang.linkPopupTop ) + '</span>'
												},
												{
													'type' : 'text',
													labelLayout : 'horizontal',
													label : '',
													id : 'popupTop'
												}
											]
										}

									]
								}
							]
						}
					]
				},
				{
					id : 'Upload',
					label : editor.lang.linkUpload,
					elements : 
					[
						{
							type : 'file',
							id : 'upload',
							label : editor.lang.upload,
							action : 'nowhere.php',
							size : 38
						},
						{
							type : 'fileButton',
							id : 'uploadButton',
							label : editor.lang.uploadSubmit,
							'for' : [ 'Upload', 'upload' ]
						}
					]
				},
				{
					id : 'Advanced',
					label : editor.lang.linkAdvanced,
					elements : 
					[
						{
							'type' : 'vbox',
							padding : 1,
							children : 
							[
								{
									'type' : 'hbox',
									widths : [ '45%', '35%', '20%' ],
									children : 
									[
										{
											'type' : 'text',
											id : 'advId',
											label : editor.lang.linkId
										},
										{
											'type' : 'select',
											id : 'advLangDir',
											label : editor.lang.linkLangDir,
											'default' : 'notSet',
											style : 'width: 100%;',
											items :
											[
												[ editor.lang.linkLangDirNotSet, 'notSet' ],
												[ editor.lang.linkLangDirLTR, 'ltr' ],
												[ editor.lang.linkLangDirRTL, 'rtl' ]
											]
										},
										{
											'type' : 'text',
											id : 'advAccessKey',
											label : editor.lang.linkAcccessKey,
											maxLength : 1
										}
									]
								},
								{
									'type' : 'hbox',
									widths : [ '45%', '35%', '20%' ],
									children : 
									[
										{
											'type' : 'text',
											label : editor.lang.linkName,
											id : 'advName',
										},
										{
											'type' : 'text',
											label : editor.lang.linkLangCode,
											id : 'advLangCode'
										},
										{
											'type' : 'text',
											label : editor.lang.linkTabIndex,
											id : 'advTabIndex',
											maxLength : 5
										}
									]
								}
							]
						},
						{
							'type' : 'vbox',
							padding : 1,
							children :
							[
								{
									'type' : 'hbox',
									widths : [ '45%', '55%' ],
									children : 
									[
										{
											'type' : 'text',
											label : editor.lang.linkAdvisoryTitle,
											id : 'advTitle'
										},
										{
											'type' : 'text',
											label : editor.lang.linkAdvisoryContentType,
											id : 'advContentType'
										}
									]
								},
								{
									'type' : 'hbox',
									widths : [ '45%', '55%' ],
									children : 
									[
										{
											'type' : 'text',
											label : editor.lang.linkCSSClasses,
											id : 'advCSSClasses'
										},
										{
											'type' : 'text',
											label : editor.lang.linkCharset,
											id : 'advCharset'
										}
									]
								},
								{
									'type' : 'hbox',
									children : 
									[
										{
											'type' : 'text',
											label : editor.lang.linkStyles,
											id : 'advStyles'
										}
									]
								}
							]
						}
					]
				},
			],
			onShow : function()
			{
				this.getContentElement( 'info', 'url' ).focus();
			}
		};
	}
};
