/*
 * FCKeditor - The text editor for Internet - http://www.fckeditor.net
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 * 
 * == BEGIN LICENSE ==
 * 
 * Licensed under the terms of any of the following licenses at your
 * choice:
 * 
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 * 
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 * 
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 * 
 * == END LICENSE ==
 */
package net.fckeditor.connector.impl;

import javax.servlet.ServletContext;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import net.fckeditor.handlers.ConnectorHandler;
import net.fckeditor.handlers.PropertiesLoader;

/**
 * TODO Document this, especially for ticket #2583
 * 
 * @version $Id: ContextConnector.java 2730 2008-11-27 19:50:11Z mosipov $
 */
public class ContextConnector extends AbstracLocalFileSystemConnector {

	private final Logger logger = LoggerFactory
			.getLogger(ContextConnector.class);

	/*
	 * (non-Javadoc)
	 * 
	 * @see net.fckeditor.connector.Connector#init()
	 */
	public void init(final ServletContext servletContext) throws Exception {

		AbstracLocalFileSystemConnector.servletContext = servletContext;
		String defaultAbsolutePath = getRealUserFilesAbsolutePath(PropertiesLoader
				.getUserFilesPath());

		if (defaultAbsolutePath == null) {
			logger.error("The context root cannot be resolved against the local filesystem");
			logger.info("Your servlet container/application server does not expand deployed war files");
			logger.debug("Use another Connector implementation (e.g. LocalConnector) and consult http://www.fckeditor.net/forums/viewtopic.php?f=6&t=11568");
			throw new NullPointerException(
					"The context root cannot be resolved against the local filesystem");
		}
	}

	@Override
	protected String getRealUserFilesAbsolutePath(String path) {
		return servletContext.getRealPath(path);
	}

}
