﻿/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */

/**
 * @fileOverview Defines the {@link CKEDITOR.lang} object, for the English
 *		language. This is the base file for all translations.
 */

/**#@+
   @type String
   @example
*/

/**
 * Constains the dictionary of language entries.
 * @namespace
 */
CKEDITOR.lang['en'] =
{
	/**
	 * The language reading direction. Possible values are "rtl" for
	 * Right-To-Left languages (like Arabic) and "ltr" for Left-To-Right
	 * languages (like English).
	 * @default 'ltr'
	 */
	dir : 'ltr',

	// Toolbar buttons without dialogs.
	source			: 'Source',
	underline		: 'Underline',
	bold			: 'Bold',
	italic			: 'Italic',
	selectAll		: 'Select All',
	removeFormat	: 'Remove Format',
	strike			: 'Strike Through',
	subscript		: 'Subscript',
	superscript		: 'Superscript',
	horizontalrule	: 'Insert Horizontal Line',
	unlink			: 'Unlink',

	// Common messages and labels.
	common :
	{
		browseServer	: 'Browser Server',
		url				: 'URL',
		protocol		: 'Protocol',
		upload			: 'Upload',
		uploadSubmit	: 'Send it to the Server',
		image			: 'Image',
		flash			: 'Flash',
		form			: 'Form',
		checkbox		: 'Checkbox',
		radio		: 'Radio Button',
		textField		: 'Text Field',
		textarea		: 'Textarea',
		hiddenField		: 'Hidden Field',
		button			: 'Button',
		select	: 'Selection Field',
		imageButton		: 'Image Button',
		ok				: 'OK',
		cancel			: 'Cancel',
		generalTab		: 'General',
		advancedTab		: 'Advanced',
		confirmCancel	: 'Some of the options have been changed. Are you sure to close the dialog?'
	},

	// Special char dialog.
	specialChar		: 
	{
		toolbar		: 'Insert Special Character',
		title		: 'Select Special Character'
	},

	// Link dialog.
	link :
	{
		toolbar		: 'Link\u200b',		// IE6 BUG: A title called "Link" in an <A> tag would invalidate its padding!!
		title		: 'Link',
		info		: 'Link Info',
		target		: 'Target',
		upload		: 'Upload',
		advanced	: 'Advanced',
		type		: 'Link Type',
		toAnchor	: 'Link to anchor in the text',
		toEmail		: 'E-mail',
		target		: 'Target',
		targetNotSet	: '<not set>',
		targetFrame	: '<frame>',
		targetPopup	: '<popup window>',
		targetNew	: 'New Window (_blank)',
		targetTop	: 'Topmost Window (_top)',
		targetSelf	: 'Same Window (_self)',
		targetParent	: 'Parent Window (_parent)',
		targetFrameName	: 'Target Frame Name',
		targetPopupName	: 'Popup Window Name',
		popupFeatures	: 'Popup Window Features',
		popupResizable	: 'Resizable',
		popupStatusBar	: 'Status Bar',
		popupLocationBar	: 'Location Bar',
		popupToolbar	: 'Toolbar',
		popupMenuBar	: 'Menu Bar',
		popupFullScreen	: 'Full Screen (IE)',
		popupScrollBars	: 'Scroll Bars',
		popupDependent	: 'Dependent (Netscape)',
		popupWidth		: 'Width',
		popupLeft		: 'Left Position',
		popupHeight		: 'Height',
		popupTop		: 'Top Position',
		id				: 'Id',
		langDir			: 'Language Direction',
		langDirNotSet	: '<not set>',
		langDirLTR		: 'Left to Right',
		langDirRTL		: 'Right to Left',
		acccessKey		: 'Access Key',
		name			: 'Name',
		langCode		: 'Language Code',
		tabIndex		: 'Tab Index',
		advisoryTitle	: 'Advisory Title',
		advisoryContentType	: 'Advisory Content Type',
		cssClasses		: 'Stylesheet Classes',
		charset			: 'Linked Resource Charset',
		styles			: 'Style',
		selectAnchor	: 'Select an Anchor',
		anchorName		: 'By Anchor Name',
		anchorId		: 'By Element Id',
		emailAddress	: 'E-Mail Address',
		emailSubject	: 'Message Subject',
		emailBody		: 'Message Body',
		noAnchors		: '(No anchors available in the document)',
		noUrl			: 'Please type the link URL',
		noEmail			: 'Please type the e-mail address'
	},

	// Dialog titles. TODO: Group these with their dialogs.
	formProp		: 'Form Properties',
	buttonProp		: 'Button Properties',
	checkboxProp	: 'Checkbox Properties',
	hiddenFieldProp	: 'Hidden Field Properties',
	radioButtonProp	: 'Radio Button Properties',
	imageButtonProp	: 'Image Button Properties',
	textFieldProp	: 'Text Field Properties',
	selectionFieldProp	: 'Selection Field Properties',
	extareaProp	: 'Textarea Properties',

	// General Dialogs Labels. TODO: Group these to common terms.
	dlgGenNotSet		: '<not set>',
	dlgGenId			: 'Id',
	dlgGenLangDir		: 'Language Direction',
	dlgGenLangDirLtr	: 'Left to Right (LTR)',
	dlgGenLangDirRtl	: 'Right to Left (RTL)',
	dlgGenLangCode		: 'Language Code',
	dlgGenAccessKey		: 'Access Key',
	dlgGenName			: 'Name',
	dlgGenTabIndex		: 'Tab Index',
	dlgGenLongDescr		: 'Long Description URL',
	dlgGenClass			: 'Stylesheet Classes',
	dlgGenTitle			: 'Advisory Title',
	dlgGenContType		: 'Advisory Content Type',
	dlgGenLinkCharset	: 'Linked Resource Charset',
	dlgGenStyle			: 'Style',

	// Find And Replace Dialog
	findAndReplace :
	{
		title				: 'Find and Replace',
		find				: 'Find',
		replace				: 'Replace',
		findWhat			: 'Find what:',
		replaceWith			: 'Replace with:',
		notFoundMsg			: 'The specified text was not found.',
		matchCase			: 'Match case',
		matchWord			: 'Match whole word',
		replaceAll			: 'Replace All'
	},

	// Table Dialog
	table :
	{
		toolbar		: 'Table',
		title		: 'Table Properties',
		rows		: 'Rows',
		columns		: 'Columns',
		border		: 'Border size',
		align		: 'Alignment',
		alignNotSet	: '<Not set>',
		alignLeft	: 'Left',
		alignCenter	: 'Center',
		alignRight	: 'Right',
		width		: 'Width',
		widthPx		: 'pixels',
		widthPc		: 'percent',
		height		: 'Height',
		cellSpace	: 'Cell spacing',
		cellPad		: 'Cell padding',
		caption		: 'Caption',
		summary		: 'Summary',
		headers		: 'Headers',
		headersNone		: 'None',
		headersColumn	: 'First column',
		headersRow		: 'First Row',
		headersBoth		: 'Both'
	},

	// Button Dialog. TODO: Group these under button.
	dlgButtonText		: 'Text (Value)',
	dlgButtonType		: 'Type',
	dlgButtonTypeBtn	: 'Button',
	dlgButtonTypeSbm	: 'Submit',
	dlgButtonTypeRst	: 'Reset',

	// Checkbox and Radio Button Dialogs. TODO: Group these under checkboxAndRadio.
	dlgCheckboxName		: 'Name',
	dlgCheckboxValue	: 'Value',
	dlgCheckboxSelected	: 'Selected',

	// Form Dialog. TODO: Group these under form.
	dlgFormName		: 'Name',
	dlgFormAction	: 'Action',
	dlgFormMethod	: 'Method',

	// Select Field Dialog. TODO: Group these under selectBox.
	dlgSelectSelectInfo	: 'Select Info',
	dlgSelectOpAvail	: 'Available Options',
	dlgSelectName		: 'Name',
	dlgSelectValue		: 'Value',
	dlgSelectSize		: 'Size',
	dlgSelectLines		: 'lines',
	dlgSelectChkMulti	: 'Allow multiple selections',
	dlgSelectOpText		: 'Text',
	dlgSelectOpValue	: 'Value',
	dlgSelectBtnAdd		: 'Add',
	dlgSelectBtnModify	: 'Modify',
	dlgSelectBtnUp		: 'Up',
	dlgSelectBtnDown	: 'Down',
	dlgSelectBtnSetValue : 'Set as selected value',
	dlgSelectBtnDelete	: 'Delete',

	// Textarea Dialog. TODO: Group these under textarea.
	dlgTextareaName	: 'Name',
	dlgTextareaCols	: 'Columns',
	dlgTextareaRows	: 'Rows',

	// Text Field Dialog. TODO: Group these under textField.
	dlgTextName			: 'Name',
	dlgTextValue		: 'Value',
	dlgTextCharWidth	: 'Character Width',
	dlgTextMaxChars		: 'Maximum Characters',
	dlgTextType			: 'Type',
	dlgTextTypeText		: 'Text',
	dlgTextTypePass		: 'Password',

	// Hidden Field Dialog. TODO: Group these under hiddenField.
	dlgHiddenName	: 'Name',
	dlgHiddenValue	: 'Value',

	// Image Dialog. TODO: Group these under image.
	dlgImgTitle		: 'Image Properties',
	dlgImgInfoTab	: 'Image Info',
	dlgImgBtnUpload	: 'Send it to the Server',
	dlgImgURL		: 'URL',
	dlgImgUpload	: 'Upload',
	dlgImgAlt		: 'Alternative Text',
	dlgImgWidth		: 'Width',
	dlgImgHeight	: 'Height',
	dlgImgLockRatio	: 'Lock Ratio',
	dlgBtnResetSize	: 'Reset Size',
	dlgImgBorder	: 'Border',
	dlgImgHSpace	: 'HSpace',
	dlgImgVSpace	: 'VSpace',
	dlgImgAlign		: 'Align',
	dlgImgAlignLeft	: 'Left',
	dlgImgAlignAbsBottom: 'Abs Bottom',
	dlgImgAlignAbsMiddle: 'Abs Middle',
	dlgImgAlignBaseline	: 'Baseline',
	dlgImgAlignBottom	: 'Bottom',
	dlgImgAlignMiddle	: 'Middle',
	dlgImgAlignRight	: 'Right',
	dlgImgAlignTextTop	: 'Text Top',
	dlgImgAlignTop	: 'Top',
	dlgImgPreview	: 'Preview',
	dlgImgAlertUrl	: 'Please type the image URL',
	dlgImgLinkTab	: 'Link',
	dlgImgTypeNumber	: 'This value is not a number.',
	dlgImgButton2Img	: 'Do you want to transform the selected image button on a simple image?',
	dlgImgImg2Button	: 'Do you want to transform the selected image on a image button?',	
	
	// Flash Dialog
	flash :
	{
		properties		: 'Flash Properties',
		dlgTitle		: 'Flash Properties',
		dlgInfoTab		: 'Flash Info',
		dlgChkPlay		: 'Auto Play',
		dlgChkLoop		: 'Loop',
		dlgChkMenu		: 'Enable Flash Menu',
		dlgScale		: 'Scale',
		dlgScaleAll		: 'Show all',
		dlgScaleNoBorder	: 'No Border',
		dlgScaleFit		: 'Exact Fit',
		dlgWidth		: 'Width',
		dlgHeight		: 'Height',
	},
	
	elementsPath :
	{
		eleTitle : '%1 element'
	}
};
