/*
 * CKEditor - The text editor for Internet - http://ckeditor.com
 * Copyright (C) 2003-2008 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 */
 

CKEDITOR.dialog.add( 'flash', function( editor ){
{
	// Load image preview.
	var showPreview = true;
	var uploadAction = 'nowhere.php';
	var regexSize = /^\s*(\d+)((px)|\%)?\s*$/i;

	var previewAreaHtml = '<div>' + CKEDITOR.tools.htmlEncode( editor.lang.dlgImgPreview ) +'<br>'+
		'<div id="FlashPreviewLoader" style="display:none"><div class="loading">&nbsp;</div></div>'+
		'<div id="FlashPreviewBox">'+
		'<span id="previewContainer"></span>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Maecenas feugiat consequat diam. Maecenas metus. Vivamus diam purus, cursus a, commodo non, facilisis vitae, nulla. Aenean dictum lacinia tortor. Nunc iaculis, nibh non iaculis aliquam, orci felis euismod neque, sed ornare massa mauris sed velit. Nulla pretium mi et risus. Fusce mi pede, tempor id, cursus ac, ullamcorper nec, enim. Sed tortor. Curabitur molestie. Duis velit augue, condimentum at, ultrices a, luctus ut, orci. Donec pellentesque egestas eros. Integer cursus, augue in cursus faucibus, eros pede bibendum sem, in tempus tellus justo quis ligula. Etiam eget tortor. Vestibulum rutrum, est ut placerat elementum, lectus nisl aliquam velit, tempor aliquam eros nunc nonummy metus. In eros metus, gravida a, gravida sed, lobortis id, turpis. </div></div>';

	var addChange = function( name, input ){
		var dialog = input.getDialog();
		
		//Don't load before onShow.
		if ( !dialog.allowOnChange )
			return 0;

		if ( input.getValue() != '' || input.isChanged() )
		{
			dialog.changedAttibutes[ 'flash' ][ name ] = input.getValue();
			return true;
		}
		return false;
	};

	var onUrlChange = function( input )
	{
		var dialog = input.getDialog();

		//Don't load before onShow.
		if ( !dialog.allowOnChange )
			return 0;

		updatePreview( dialog );
	}

	var onChange = function( input, attribute )
	{
		var dialog = input.getDialog();

		//Don't load before onShow.
		if ( !dialog.allowOnChange )
			return 0;

		updatePreview( dialog );
	}

	var updatePreview = function( dialog )
	{
		if ( !dialog.editObj[ 'preview' ] )
			return 1;

		// Check value
		var aMatch  =  value.match( regexSize );
		if ( aMatch )
		{
			// % is allowed
			if ( aMatch[2] == '%' )
				aMatch[1] += '%';
			value = aMatch[1];
		}

		// Read attributes
		//dialog.editObj[ 'preview' ].setAttribute( 'border', border );	
		//dialog.editObj[ 'preview' ].setStyle( 'border', border + 'px solid black' );

		return 0;
	}

	var readSize = function( dialog )
	{
		var heightText = '';
		var widthText = '';

		// Read height.
		if ( dialog.editObj[ 'fakeimage' ].getAttribute( 'height' ) )
		{
			var aMatchH  =  dialog.editObj[ 'fakeimage' ].getAttribute( 'height' ).match( regexSize );
			if ( aMatchH )
			{
				// % is allowed.
				if ( aMatchH[2] == '%' )
					aMatchH[1] += '%';
				heightText = aMatchH[1];
			}
		}

		// Read width.
		if ( dialog.editObj[ 'fakeimage' ].getAttribute( 'width' ) )
		{
			var aMatchW  =  dialog.editObj[ 'fakeimage' ].getAttribute( 'width' ).match( regexSize );
			if ( aMatchW )
			{
				// % is allowed.
				if ( aMatchW[2] == '%' )
					aMatchW[1] += '%';
				widthText = aMatchW[1];
			}
		}

		// Read styles.
		var aMatchW  =  dialog.editObj[ 'fakeimage' ].$.style.width.match( regexSize );
		if ( aMatchW )
		{
			// % is allowed.
			if ( aMatchW[2] == '%' )
				aMatchW[1] += '%';
			widthText = aMatchW[1];
			dialog.changedAttibutes[ 'flash' ][ 'width' ] = widthText;
			dialog.dimensionsInStyle[ 'width' ] = true;
		}
		var aMatchH  =  dialog.editObj[ 'fakeimage' ].$.style.height.match( regexSize );
		if ( aMatchH )
		{
			// % is allowed.
			if ( aMatchH[2] == '%' )
				aMatchH[1] += '%';
			heightText = aMatchH[1];
			dialog.changedAttibutes[ 'flash' ][ 'height' ] = heightText;
			dialog.dimensionsInStyle[ 'height' ] = true;
		}

		var allow = dialog.allowOnChange;
		dialog.allowOnChange = false;
		dialog.setValueOf( 'info', 'txtHeight', heightText );
		dialog.setValueOf( 'info', 'txtWidth', widthText );
		dialog.allowOnChange = allow;
	}

	// Function called in onShow to load selected element.
	var loadElements = function( editor, selection, ranges, element )
	{
		this.saveSelection();
		this.editMode[ 'fakeimage' ] = true;
		this.editObj[ 'fakeimage' ] = element;


		//TODO: this.editObj[ 'flash' ] = getRealElement (element);


		// Fill out all fields.
		if ( !readAttribute.apply( this, [ 'info', '_cke_saved_url', 'txtUrl', imgObject ] ) )
			readAttribute.apply( this, [ 'info', 'src', 'txtUrl', imgObject ] )

		readAttribute.apply( this, [ 'advanced', 'id', 'cmbScale', imgObject ] );
		readAttribute.apply( this, [ 'advanced', 'play', 'txtChkPlay', imgObject ] );
		readAttribute.apply( this, [ 'advanced', 'loop', 'txtChkLoop', imgObject ] );
		readAttribute.apply( this, [ 'advanced', 'menu', 'txtChkMenu', imgObject ] );
		readAttribute.apply( this, [ 'advanced', 'id', 'txtGenId', imgObject ] );
		readAttribute.apply( this, [ 'advanced', 'class', 'txtGenClass', imgObject ] );	
		readAttribute.apply( this, [ 'advanced', 'style', 'txtGenStyle', imgObject ] );
		readAttribute.apply( this, [ 'advanced', 'title', 'txtGenTitle', imgObject ] );

		readSize( this );
		updatePreview( this );

		return false;
	};
	
	var readAttribute = function( page, attribute, input, object )
	{
		var attributeValue = object.getAttribute( attribute );
		if ( attributeValue == null )
			this.setValueOf( page, input, "" );
		else
			this.setValueOf( page, input, attributeValue );

		return attributeValue;
	}

	return {
		title : editor.lang.flash.properties,
		minWidth : 450,
		minHeight : 400,
		onOk : function()
		{
			this.allowOnChange = true;

			// Create a new fakeimage.
			if ( !this.editMode[ 'fakeimage' ] )
			{
				this.editObj[ 'fakeimage' ] = editor.document.createElement( 'img' );

				this.editObj[ 'fakeimage' ].setAttribute ( '_cke_flash', 'true' );
				
				// TODO: where is spacer.gif? (problem with path to spacer.gif)
				this.editObj[ 'fakeimage' ].setAttribute ( 'src' ,'spacer.gif' );
				
				//TODO: Move ....somewhere (problem with path to flashlogo.gif)
/*
.cke_flash
{
	border: #a9a9a9 1px solid;
	background-position: center center;
	background-image: url(images/flashlogo.gif);
	background-repeat: no-repeat;
	width: 80px;
	height: 80px;
}
*/
				this.editObj[ 'fakeimage' ].setStyle ( 'class', 'cke_flash' );
			}
			
			// Create a new flash object.
			if ( !this.editMode[ 'fakeimage' ] )
			{
				this.editObj[ 'flash' ] = editor.document.createElement( 'embed' );
				
				// TODO: this.editObj[ 'fakeimage' ].setRealemenet( this.editObj[ 'flash' ] );
			}

			// Set flash attributes.
			this.editObj[ 'flash' ].setAttributes( this.changedAttibutes[ 'flash' ] );

			// Set STYLE dimensions.
			if ( this.dimensionsInStyle[ 'width' ] == true )
			{
				this.editObj[ 'flash' ].setStyle( 'width',  this.changedAttibutes[ 'flash' ][ 'width' ] + 'px' );
				this.editObj[ 'fakeimage' ].setStyle( 'width',  this.changedAttibutes[ 'flash' ][ 'width' ] + 'px' );
			}
			if ( this.dimensionsInStyle[ 'height' ] == true )
			{
				this.editObj[ 'flash' ].setStyle( 'height',  this.changedAttibutes[ 'flash' ][ 'height' ] + 'px' );
				this.editObj[ 'fakeimage' ].setStyle( 'height',  this.changedAttibutes[ 'flash' ][ 'height' ] + 'px' );
			}

			// Insert a new fakeimage.
			if ( this.editMode[ 'fakeimage' ] == false )
			{
				// It doesn't work with IE.
				this.restoreSelection();
				this.clearSavedSelection();
				editor.insertElement( this.editObj[ 'fakeimage' ] );
			}
			this.allowOnChange = false;		// Don't load onChange before onShow.

			return true;
		},
		onShow : function()
		{
			//Don't call onShow before onShow.
			this.allowOnChange = false;

			this.editObj = new Array();
			this.editObj[ 'fakeimage' ] = false;
			this.editObj[ 'preview' ] = false;
			this.editObj[ 'flash' ] = false;
			
			// Default: create a new element.
			this.editMode = new Array();
			this.editMode[ 'fakeimage' ] = false;

			this.changedAttibutes = new Array();
			this.changedAttibutes[ 'flash' ] = new Array();

			this.dimensionsInStyle = new Array();
			this.dimensionsInStyle[ 'width' ] = false;
			this.dimensionsInStyle[ 'height' ] = false;

			// IE BUG: Selection must be in the editor for getSelection() to work.
			this.restoreSelection();

			var editor = this.getParentEditor(),
				selection = editor.getSelection(),
				ranges = selection.getRanges();

			if ( ranges.length == 1 )
			{
				element = false;
				ranges[0].enlarge( CKEDITOR.ENLARGE_ELEMENT );
				rangeRoot = ranges[0].getCommonAncestor( true );
				
				elementImg = rangeRoot.getAscendant( 'img', true );
				if ( elementImg && elementA.getAttribute( '_cke_flash' ) )
				{
					loadElements.apply( this, [ editor, selection, ranges, elementImg ] );
					selection.selectElement( elementImg );
					this.saveSelection();
				}
			}
			updatePreview( this );

			this.allowOnChange = true;
			this.pushDefault();
			this.getContentElement( 'info', 'txtUrl' ).focus();
		},		
		onLoad : function()
		{
			if ( editor.config.imageUpload == false )
				this.hidePage( 'Upload' );		//Hide Upload tab.

		},	
		onHide : function()
		{
			if ( this.editObj[ 'preview' ] )
				this.editObj[ 'preview' ].setAttribute( 'src', '' );

			this.editObj[ 'preview' ] = false;

			// Don't call onChange before onShow.
			this.allowOnChange = false;

			// Pop the default values from default value set that are pushed in onShow().
			this.popDefault();
		},
		contents : [
			{
				id : 'info',
				label : editor.lang.flash.dlgInfoTab,
				accessKey : 'I',
				elements :
				[
					{
						type : 'vbox',
						padding : 0,
						children :
						[
							{
								type : 'html',
								html : '<span>' + CKEDITOR.tools.htmlEncode( editor.lang.dlgImgURL ) + '</span>'
							},
							{
								type : 'hbox',
								widths : [ '280px', '110px' ],
								align : 'right',
								children :
								[
									{
										id : 'txtUrl',
										type : 'text',
										label : '',
										validate: function()
										{
											addChange( 'src', this );
											addChange( '_cke_saved_url', this );
											return true;
										},
										onChange : function(){
											onUrlChange( this );
										}
									},
									{
										type : 'button',
										id : 'browse',
										align : 'center',
										label : editor.lang.common.browseServer,
										onClick : function()
										{
											//this.getDialog().setValueOf( "info", "txtUrl", "http://www.fckeditor.net/images/demo_screenshot.gif" );
										}
									}
								]
							}
						]
					},
					{
						type : 'hbox',
						widths : [ '20%', '20%', '60%' ],
						children :
						[
							{
								type : 'text',
								id : 'txtWidth',
								label : editor.lang.flash.dlgWidth,
								onChange : function()
								{
									onChange( this );
								},
								validate: function()
								{
									var aMatch  =  this.getValue().match( regexSize );
									if ( this.getValue() != '' && aMatch )
									{
										if ( aMatch[2] == '%' )
											aMatch[1] += '%';
										addChange( 'width', this );
										return true;
									}
									return false;
								}
							},
							{
								type : 'text',
								id : 'txtHeight',
								label : editor.lang.flash.dlgHeight,
								onChange : function()
								{
									onChange( this );
								},
								validate: function()
								{
									var aMatch  =  this.getValue().match( regexSize );
									if ( this.getValue() != '' && aMatch )
									{
										if ( aMatch[2] == '%' )
											aMatch[1] += '%';
										addChange( 'height', this );
										return true;
									}
									return false;
								}
							},
							{
								type : 'html',
								html : '<div></div>'
							}
						]
					},

					{
						type : 'vbox',
						children :
						[
							{
								type : 'html',
								style : 'width:95%;',
								html : previewAreaHtml
							}
						]
					}
				]
			},
			{
				id : 'Upload',
				label : editor.lang.common.upload,
				elements :
				[
					{
						type : 'file',
						id : 'upload',
						label : editor.lang.common.upload,
						action : uploadAction,
						size : 38
					},
					{
						type : 'fileButton',
						id : 'uploadButton',
						label : editor.lang.common.uploadSubmit,
						'for' : [ 'Upload', 'upload' ]
					}
				]
			},
			{
				id : 'advanced',
				label : editor.lang.common.advancedTab,
				elements :
				[
					{
						type : 'hbox',
						widths : [ '25%', '25%', '25%', '25%'],
						children :
						[
							{
								id : 'cmbScale',
								type : 'select',
								label : editor.lang.flash.dlgScale,
								style : 'width : 100%;',
								items :
								[
									[ '', '' ],
									[ editor.lang.flash.dlgScaleAll, 'showall' ],
									[ editor.lang.flash.dlgScaleNoBorder, 'noborder' ],
									[ editor.lang.flash.dlgScaleFit, 'exactfit' ]
								],
								validate : function()
								{
									addChange( 'scale', this );
									return true;
								}
							},
							{
								type : 'checkbox',
								id : 'txtChkPlay',
								label : editor.lang.flash.dlgChkPlay,
								validate : function()
								{
									addChange( 'play', this );
									return true;
								}
							},
							{
								type : 'checkbox',
								id : 'txtChkLoop',
								label : editor.lang.flash.dlgChkLoop,
								validate : function()
								{
									addChange( 'loop', this );
									return true;
								}
							},
							{
								type : 'checkbox',
								id : 'txtChkMenu',
								label : editor.lang.flash.dlgChkMenu,
								validate : function()
								{
									addChange( 'menu', this );
									return true;
								}
							},
						]
					},
					{
						type : 'hbox',
						widths : [ '50%', '25%', '25%' ],
						children :
						[
							{
								type : 'text',
								id : 'txtGenId',
								label : editor.lang.dlgGenId,
								validate : function()
								{
									addChange( 'id', this );
									return true;
								}
							},
							{
								type : 'text',
								id : 'txtGenClass',
								label : editor.lang.dlgGenClass,
								validate : function()
								{
									addChange( 'class', this );
									return true;
								}
							},
							{
								type : 'text',
								id : 'txtGenTitle',
								label : editor.lang.dlgGenTitle,
								validate : function()
								{
									addChange( 'title', this );
									return true;
								}
							}
						]
					},
					{
						type : 'text',
						id : 'txtdlgGenStyle',
						label : editor.lang.dlgGenStyle,
						validate : function()
						{				
							addChange( 'style', this );
							return true;
						}
					}
				]
			}
		]
	};
};

});
