/*
 * FCKeditor - The text editor for Internet - http://www.fckeditor.net
 * Copyright (C) 2004-2009 Frederico Caldeira Knabben
 * 
 * == BEGIN LICENSE ==
 * 
 * Licensed under the terms of any of the following licenses at your
 * choice:
 * 
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 * 
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 * 
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 * 
 * == END LICENSE ==
 */
package net.fckeditor.requestcycle;

import javax.servlet.http.HttpServletRequest;

/**
 * Container for {@link ThreadLocal}s.<br>
 *
 * @version $Id: ThreadLocalData.java 2868 2009-01-09 21:54:36Z mosipov $
 */
public class ThreadLocalData {
	private static ThreadLocal<HttpServletRequest> request = new ThreadLocal<HttpServletRequest>();
	private static ThreadLocal<Context> context = new ThreadLocal<Context>();
	
	public static void beginRequest(final HttpServletRequest request) {
		if (request == null)
			throw new NullPointerException();
		ThreadLocalData.request.set(request);
		ThreadLocalData.context.set(new Context(request));
	}
	
	public static HttpServletRequest getRequest() {
		return request.get();
	}
	
	 public static Context getContext() {
		 return context.get();
	 }
	
	/**
	 * Clear the ThreadLocals.<br>
	 * <strong>Important: To prevent memory leaks we have to make sure that this
	 * method is calling at the end of each request cycle!!!</strong>
	 */
	public static void endRequest() {
		request.remove();
		context.remove();
	}
}
