/*
Copyright (c) 2003-2009, CKSource - Frederico Knabben. All rights reserved.
For licensing, see LICENSE.html or http://ckeditor.com/license
*/

CKEDITOR.dialog.add( 'flash', function( editor ){
{
	const PARAM = 1,
	OBJECT = 2,
	EMBED = 4;

	var regexSize = /^\s*(\d+)((px)|\%)?\s*$/i,
	regexValidSize = /^(\d+)\%?$|^$/i;

	var previewAreaHtml = '<div>' + CKEDITOR.tools.htmlEncode( editor.lang.image.preview ) +'<br>'+
		'<div id="FlashPreviewLoader" style="display:none"><div class="loading">&nbsp;</div></div>'+
		'<div id="FlashPreviewBox">'+
		'<span id="previewContainer"></span>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Maecenas feugiat consequat diam. Maecenas metus. Vivamus diam purus, cursus a, commodo non, facilisis vitae, nulla. Aenean dictum lacinia tortor. Nunc iaculis, nibh non iaculis aliquam, orci felis euismod neque, sed ornare massa mauris sed velit. Nulla pretium mi et risus. Fusce mi pede, tempor id, cursus ac, ullamcorper nec, enim. Sed tortor. Curabitur molestie. Duis velit augue, condimentum at, ultrices a, luctus ut, orci. Donec pellentesque egestas eros. Integer cursus, augue in cursus faucibus, eros pede bibendum sem, in tempus tellus justo quis ligula. Etiam eget tortor. Vestibulum rutrum, est ut placerat elementum, lectus nisl aliquam velit, tempor aliquam eros nunc nonummy metus. In eros metus, gravida a, gravida sed, lobortis id, turpis. </div></div>';

	var addChange = function( name, input, tag ){
		var dialog = input.getDialog();
		var result = false;

		//Don't load before onShow.
		if ( !dialog.allowOnChange )
			return 0;

		if ( tag & PARAM )
			if ( input.getValue() != '' || input.isChanged() )
			{
				dialog.changedAttibutes[ 'PARAM' ][ name ] = input.getValue();
				result = true;
			}
		if ( tag & OBJECT )
			if ( input.getValue() != '' || input.isChanged() )
			{
				dialog.changedAttibutes[ 'OBJECT' ][ name ] = input.getValue();
				result = true;
			}
		if ( tag & EMBED )
			if ( input.getValue() != '' || input.isChanged() )
			{
				dialog.changedAttibutes[ 'EMBED' ][ name ] = input.getValue();
				result = true;
			}

		return result;
	};

	var onUrlChange = function( input )
	{
		var dialog = input.getDialog();
		//Don't load before onShow.
		if ( !dialog.allowOnChange )
			return 0;

		updatePreview( dialog );
	}

	var onChange = function( input, attribute )
	{
		var dialog = input.getDialog();
		//Don't load before onShow.
		if ( !dialog.allowOnChange )
			return 0;

		updatePreview( dialog );
	}

	var updatePreview = function( dialog )
	{
		if ( !dialog.editObj[ 'preview' ] )
			return 1;
		// Check value
		var aMatch  =  value.match( regexSize );
		if ( aMatch )
		{
			// % is allowed
			if ( aMatch[2] == '%' )
				aMatch[1] += '%';
			value = aMatch[1];
		}

		// Read attributes
		//dialog.editObj[ 'preview' ].setAttribute( 'border', border );
		//dialog.editObj[ 'preview' ].setStyle( 'border', border + 'px solid black' );

		return 0;
	}

	var readSize = function( dialog, mainObject )
	{
		var heightText = '';
		var widthText = '';

		// Read height.
		if ( mainObject.getAttribute( 'height' ) )
		{
			var aMatchH  =  mainObject.getAttribute( 'height' ).match( regexSize );
			if ( aMatchH )
			{
				// % is allowed.
				if ( aMatchH[2] == '%' )
					aMatchH[1] += '%';
				heightText = aMatchH[1];
			}
		}

		// Read width.
		if ( mainObject.getAttribute( 'width' ) )
		{
			var aMatchW  =  mainObject.getAttribute( 'width' ).match( regexSize );
			if ( aMatchW )
			{
				// % is allowed.
				if ( aMatchW[2] == '%' )
					aMatchW[1] += '%';
				widthText = aMatchW[1];
			}
		}

		// Read styles.
		var aMatchW  =  mainObject.$.style.width.match( regexSize );
		if ( aMatchW )
		{
			// % is allowed.
			if ( aMatchW[2] == '%' )
				aMatchW[1] += '%';
			widthText = aMatchW[1];
			dialog.changedAttibutes[ 'OBJECT' ][ 'width' ] = widthText;
			dialog.changedAttibutes[ 'EMBED' ][ 'width' ] = widthText;
			dialog.dimensionsInStyle[ 'width' ] = true;
		}
		var aMatchH  =  mainObject.$.style.height.match( regexSize );
		if ( aMatchH )
		{
			// % is allowed.
			if ( aMatchH[2] == '%' )
				aMatchH[1] += '%';
			heightText = aMatchH[1];
			dialog.changedAttibutes[ 'OBJECT' ][ 'height' ] = heightText;
			dialog.changedAttibutes[ 'EMBED' ][ 'height' ] = heightText;
			dialog.dimensionsInStyle[ 'height' ] = true;
		}

		var allow = dialog.allowOnChange;
		dialog.allowOnChange = false;
		dialog.setValueOf( 'info', 'txtHeight', heightText );
		dialog.setValueOf( 'info', 'txtWidth', widthText );
		dialog.allowOnChange = allow;
	}

	var addParam = function( object, name, value )
	{
		var param = editor.document.createElement( 'param' );
		param.setAttribute( 'value' , value );
		param.setAttribute( 'name' , name );
		object.append( param );
		return param;
	}

	// Function called in onShow to load selected element.
	var loadElements = function( editor, selection, ranges, fakeElement, realElement )
	{
		selection.selectElement( fakeElement );
		this.saveSelection();
		this.editMode[ 'fakeobject' ] = realElement.getName();
		this.editObj[ 'fakeobject' ] = fakeElement;

		// Object element is selected
		if ( this.editMode[ 'fakeobject' ] == 'object' ){
			this.editObj[ 'embed' ] = false;
			this.editObj[ 'object' ] = realElement;
			var childCount = realElement.getChildCount();
			var childObj;

			// Search for Embed element.
			for ( var i = 0; i < childCount; i++ )
			{
				childObj = realElement.getChild( i )
				if ( childObj && childObj.getName() == 'embed' )
				{
					this.editObj[ 'embed' ] = childObj;
					break;
				}
			}
		}
		else		// EMBED element is selected. RealTagName = embed.
		{
			this.editObj[ 'object' ] = false;
			this.editObj[ 'embed' ] = realElement;
		}

		// 1. step - read EMBED element.
		if ( this.editObj[ 'embed' ] ){
			// Fill out all fields.
			var embedElement = this.editObj[ 'embed' ];
			/*
			readAttribute.apply( this, [ 'advanced', 'id', 'cmbScale', embedElement ] );
			readAttribute.apply( this, [ 'advanced', 'play', 'txtChkPlay', embedElement ] );
			readAttribute.apply( this, [ 'advanced', 'loop', 'txtChkLoop', embedElement ] );
			readAttribute.apply( this, [ 'advanced', 'menu', 'txtChkMenu', embedElement ] );
			readAttribute.apply( this, [ 'advanced', 'id', 'txtGenId', embedElement ] );
			readAttribute.apply( this, [ 'advanced', 'class', 'txtGenClass', embedElement ] );
			readAttribute.apply( this, [ 'advanced', 'style', 'txtGenStyle', embedElement ] );
			readAttribute.apply( this, [ 'advanced', 'title', 'txtGenTitle', embedElement ] );
			*/
		}

		// 2. step - read OBJECT element
		if ( this.editObj[ 'object' ] ){
			var objectElement = this.editObj[ 'object' ];
			/*
			readAttribute.apply( this, [ 'advanced', 'id', 'cmbScale', objectElement ] );
			readAttribute.apply( this, [ 'advanced', 'play', 'txtChkPlay', objectElement ] );
			readAttribute.apply( this, [ 'advanced', 'loop', 'txtChkLoop', objectElement ] );
			readAttribute.apply( this, [ 'advanced', 'menu', 'txtChkMenu', objectElement ] );
			readAttribute.apply( this, [ 'advanced', 'id', 'txtGenId', objectElement ] );
			readAttribute.apply( this, [ 'advanced', 'class', 'txtGenClass', objectElement ] );
			readAttribute.apply( this, [ 'advanced', 'style', 'txtGenStyle', objectElement ] );
			readAttribute.apply( this, [ 'advanced', 'title', 'txtGenTitle', objectElement ] );
			*/
			// 3. step - read OBJECT params (the most important)
			var params = readParams( objectElement );
			//TODO: read params.
		}
		if ( this.editObj[ 'object' ] )
			readSize( this, this.editObj[ 'object' ] );
		else
			readSize( this, this.editObj[ 'embed' ] );

		updatePreview( this );

		return false;
	};

	var readParams = function( object )
	{
		var params = new Array(),
			name,
			value,
			i,
			childCount = object.getChildCount();

		// Search for PARAM elements.
		for ( i = 0; i < childCount; i++ )
		{
			childObj = object.getChild( i )
			if ( childObj && childObj.getName() == 'param' )
			{
				name = childObj.getAttribute( 'name' );
				value = childObj.getAttribute( 'value' );
				if ( name && value )
					params[ name ] = value;
			}
		}
		return params;
	}

	var readAttribute = function( page, attribute, input, object )
	{
		var attributeValue = object.getAttribute( attribute );
		if ( attributeValue == null )
			this.setValueOf( page, input, "" );
		else
			this.setValueOf( page, input, attributeValue );

		return attributeValue;
	}

	return {
		title : editor.lang.flash.title,
		minWidth : 450,
		minHeight : 400,
		onLoad : function()
		{
			if ( editor.config.pluginConfig.flash.uploadTab == false )
				this.hidePage( 'Upload' );		//Hide Upload tab.

			if ( editor.config.pluginConfig.flash.showAdvancedTab == false )
				this.hidePage( 'advanced' );		//Hide Advanded tab.

			if ( editor.config.pluginConfig.flash.showPropertiesTab == false )
				this.hidePage( 'advanced' );		//Hide Proporties tab.

			if ( editor.config.pluginConfig.flash.browseServer == false )
				this.getContentElement( 'info', 'browse' ).getElement().hide();

			if ( editor.config.pluginConfig.flash.embedTagOnly )
				editor.config.pluginConfig.flash.addEmbedTag = true;
		},
		onHide : function()
		{
			if ( this.editObj[ 'preview' ] )
				this.editObj[ 'preview' ].setAttribute( 'src', '' );

			this.editObj[ 'preview' ] = false;

			// Don't call onChange before onShow.
			this.allowOnChange = false;

			// Pop the default values from default value set that are pushed in onShow().
			this.popDefault();
		},
		onShow : function()
		{
			//Don't call onShow before onShow.
			this.allowOnChange = false;

			this.editObj = new Array();
			this.editObj[ 'fakeobject' ] = false;
			this.editObj[ 'preview' ] = false;
			this.editObj[ 'object' ] = false;
			this.editObj[ 'embed' ] = false;

			// Default: create a new element.
			this.editMode = new Array();
			this.editMode[ 'fakeobject' ] = false;

			this.changedAttibutes = new Array();
			this.changedAttibutes[ 'PARAM' ] = new Array();
			this.changedAttibutes[ 'OBJECT' ] = new Array();
			this.changedAttibutes[ 'EMBED' ] = new Array();

			this.dimensionsInStyle = new Array();
			this.dimensionsInStyle[ 'width' ] = false;
			this.dimensionsInStyle[ 'height' ] = false;

			// IE BUG: Selection must be in the editor for getSelection() to work.
			this.restoreSelection();

			var editor = this.getParentEditor(),
				selection = editor.getSelection(),
				ranges = selection.getRanges();

			if ( ranges.length == 1 )
			{
				ranges[0].enlarge( CKEDITOR.ENLARGE_ELEMENT );
				rangeRoot = ranges[0].getCommonAncestor( true );
				var element = rangeRoot.getAscendant( 'img', true );
				if ( element && element.getAttribute( '_cke_real_element_type' ) )
				{
					// Restore real element.
					var tempObj = CKEDITOR.plugins.fakeobjects.restoreElement( element );
					// Flash (EMBED tag)
					if ( element.getAttribute( '_cke_real_element_type' ) == 'flash' )
					{
						loadElements.apply( this, [ editor, selection, ranges, element, tempObj ] );
					}
					else if ( element.getAttribute( '_cke_real_element_type' ) == 'object' )
						// Flash (OBJECT tag)
						if ( tempObj.getAttribute( 'type' ) == 'application/x-shockwave-flash' )
						{
							loadElements.apply( this, [ editor, selection, ranges, element, tempObj ] );
						}
				}
			}
			updatePreview( this );

			this.allowOnChange = true;
			this.pushDefault();
			this.getContentElement( 'info', 'txtUrl' ).focus();
		},
		onOk : function()
		{
			this.allowOnChange = true;

			// Create a new flash.
			if ( !this.editMode[ 'fakeobject' ] )
			{
				if ( editor.config.pluginConfig.flash.embedTagOnly != true  )
					this.editObj[ 'object' ] = editor.document.createElement( 'object' );
				if ( editor.config.pluginConfig.flash.addEmbedTag == true )
					this.editObj[ 'embed' ] = editor.document.createElement( 'embed' );
			}

			this.changedAttibutes[ 'EMBED' ][ 'type' ] = "application/x-shockwave-flash";
			this.changedAttibutes[ 'OBJECT' ][ 'type' ] = "application/x-shockwave-flash";

			// Set flash attributes.
			this.editObj[ 'object' ].setAttributes( this.changedAttibutes[ 'OBJECT' ] );
			this.editObj[ 'embed' ].setAttributes( this.changedAttibutes[ 'EMBED' ] );

			// Add PARAMs.
			if ( editor.config.pluginConfig.flash.embedTagOnly != true )
				for ( var name in this.changedAttibutes[ 'PARAM' ] ){
					addParam( this.editObj[ 'object' ], name, this.changedAttibutes[ 'PARAM' ][ name ] );
				}

			// Set STYLE dimensions.
			if ( this.dimensionsInStyle[ 'width' ] == true )
			{
				var value = this.changedAttibutes[ 'OBJECT' ][ 'width' ] + 'px';
				this.editObj[ 'embed' ].setStyle( 'width', value );
				this.editObj[ 'object' ].setStyle( 'width',  value );
				this.editObj[ 'fakeobject' ].setStyle( 'width', value );
			}
			if ( this.dimensionsInStyle[ 'height' ] == true )
			{
				var value = this.changedAttibutes[ 'OBJECT' ][ 'height' ] + 'px';
				this.editObj[ 'embed' ].setStyle( 'height', value );
				this.editObj[ 'object' ].setStyle( 'height', value );
				this.editObj[ 'fakeobject' ].setStyle( 'height', value );
			}

			// Insert a new fakeobject.
			if ( this.editMode[ 'fakeobject' ] == false )
			{
				// Append EMBED as child.
				if ( editor.config.pluginConfig.flash.embedTagOnly != true && editor.config.pluginConfig.flash.addEmbedTag )
					this.editObj[ 'object' ].append( this.editObj[ 'embed' ] );

				if ( editor.config.pluginConfig.flash.embedTagOnly )
					this.editObj[ 'fakeobject' ] = CKEDITOR.plugins.fakeobjects.protectElement( this.editObj[ 'embed' ] );
				else
					this.editObj[ 'fakeobject' ] = CKEDITOR.plugins.fakeobjects.protectElement( this.editObj[ 'object' ] );

				// It doesn't work with IE.
				this.restoreSelection();
				this.clearSavedSelection();
				editor.insertElement( this.editObj[ 'fakeobject' ] );
			}
			else
			{
				CKEDITOR.plugins.fakeobjects.updateFakeElement( this.editObj[ 'fakeobject' ], this.editObj[ 'object' ] );
			}
			this.allowOnChange = false;		// Don't load onChange before onShow.

			return true;
		},
		contents : [
			{
				id : 'info',
				label : editor.lang.common.generalTab,
				accessKey : 'I',
				elements :
				[
					{
						type : 'vbox',
						padding : 0,
						children :
						[
							{
								type : 'html',
								html : '<span>' + CKEDITOR.tools.htmlEncode( editor.lang.image.url ) + '</span>'
							},
							{
								type : 'hbox',
								widths : [ '280px', '110px' ],
								align : 'right',
								children :
								[
									{
										id : 'txtUrl',
										type : 'text',
										label : '',
										validate: function()
										{
											addChange( 'movie', this, PARAM );
											addChange( 'src', this, EMBED );
											addChange( 'data', this, OBJECT );
											return true;
										},
										onChange : function(){
											onUrlChange( this );
										}
									},
									{
										type : 'button',
										id : 'browse',
										align : 'center',
										label : editor.lang.common.browseServer,
										onClick : function()
										{
											this.getDialog().setValueOf( "info", "txtUrl", "http://www.w3schools.com/flash/mouse.swf" );
										}
									}
								]
							}
						]
					},
					{
						type : 'hbox',
						widths : [ '25%', '25%', '25%', '25%', '25%' ],
						children :
						[
							{
								type : 'text',
								id : 'txtWidth',
								label : editor.lang.flash.width,
								'default' : editor.config.pluginConfig.flash.defaultValues.width,
								onChange : function()
								{
									onChange( this );
								},
								validate: function()
								{
									var aMatch  =  this.getValue().match( regexValidSize );
									if ( aMatch )
									{
										addChange( 'width', this, OBJECT | EMBED );
										return true;
									}
									alert( editor.lang.common.validateNumberFailed );
									return false;
								}
							},
							{
								type : 'text',
								id : 'txtHeight',
								label : editor.lang.flash.height,
								'default' : editor.config.pluginConfig.flash.defaultValues.height,
								onChange : function()
								{
									onChange( this );
								},
								validate: function()
								{
									var aMatch  =  this.getValue().match( regexValidSize );
									if ( aMatch )
									{
										addChange( 'height', this, OBJECT | EMBED );
										return true;
									}
									alert( editor.lang.common.validateNumberFailed );
									return false;
								}
							},
							{
								type : 'text',
								id : 'txtHSpace',
								label : editor.lang.flash.hSpace,
								'default' : editor.config.pluginConfig.flash.defaultValues.hSpace,
								onChange : function()
								{
									onChange( this );
								},
								validate: function()
								{
									var aMatch  =  this.getValue().match( regexValidSize );
									if ( aMatch )
									{
										addChange( 'hSpace', this, OBJECT | EMBED );
										return true;
									}
									alert( editor.lang.common.validateNumberFailed );
									return false;
								}
							},
							{
								type : 'text',
								id : 'txtVSpace',
								label : editor.lang.flash.vSpace,
								'default' : editor.config.pluginConfig.flash.defaultValues.vSpace,
								onChange : function()
								{
									onChange( this );
								},
								validate: function()
								{
									var aMatch  =  this.getValue().match( regexValidSize );
									if ( aMatch )
									{
										addChange( 'vSpace', this, OBJECT | EMBED );
										return true;
									}
									alert( editor.lang.common.validateNumberFailed );
									return false;
								}
							}
						]
					},

					{
						type : 'vbox',
						children :
						[
							{
								type : 'html',
								style : 'width:95%;',
								html : previewAreaHtml
							}
						]
					}
				]
			},
			{
				id : 'Upload',
				label : editor.lang.common.upload,
				elements :
				[
					{
						type : 'file',
						id : 'upload',
						label : editor.lang.common.upload,
						action : editor.config.pluginConfig.image.uploadAction,
						size : 38
					},
					{
						type : 'fileButton',
						id : 'uploadButton',
						label : editor.lang.common.uploadSubmit,
						'for' : [ 'Upload', 'upload' ]
					}
				]
			},
			{
				id : 'properties',
				label : editor.lang.flash.propertiesTab,
				elements :
				[
					{
						type : 'hbox',
						widths : [ '50%', '50%' ],
						children :
						[
							{
								id : 'cmbScale',
								type : 'select',
								label : editor.lang.flash.scale,
								'default' : editor.config.pluginConfig.flash.defaultValues.scale,
								style : 'width : 100%;',
								items :
								[
									[ editor.lang.common.notSet , ''],
									[ editor.lang.flash.scaleAll, 'showall' ],
									[ editor.lang.flash.scaleNoBorder, 'noborder' ],
									[ editor.lang.flash.scaleFit, 'exactfit' ]
								],
								validate : function()
								{
									addChange( 'scale', this, PARAM | EMBED );
									return true;
								}
							},
							{
								id : 'cmbAccess',
								type : 'select',
								label : editor.lang.flash.access,
								'default' : editor.config.pluginConfig.flash.defaultValues.access,
								style : 'width : 100%;',
								items :
								[
									[ editor.lang.common.notSet , ''],
									[ editor.lang.flash.accessAlways, 'always' ],
									[ editor.lang.flash.accessSameDomain, 'samedomain' ],
									[ editor.lang.flash.accessNever, 'never' ]
								],
								validate : function()
								{
									addChange( 'allowscriptaccess', this, PARAM | EMBED );
									return true;
								}
							}
						]
					},
					{
						type : 'hbox',
						widths : [ '50%', '50%' ],
						children :
						[
							{
								id : 'cmbWmode',
								type : 'select',
								label : editor.lang.flash.windowMode,
								'default' : editor.config.pluginConfig.flash.defaultValues.windowMode,
								style : 'width : 100%;',
								items :
								[
									[ editor.lang.common.notSet , ''],
									[ 'window' ],
									[ 'opaque' ],
									[ 'transparent' ]
								],
								validate : function()
								{
									addChange( 'wmode', this, PARAM | EMBED );
									return true;
								}
							},
							{
								id : 'cmbQuality',
								type : 'select',
								label : editor.lang.flash.quality,
								'default' : editor.config.pluginConfig.flash.defaultValues.quality,
								style : 'width : 100%;',
								items :
								[
									[ editor.lang.common.notSet , ''],
									[ 'best' ],
									[ 'high' ],
									[ 'autohigh' ],
									[ 'medium' ],
									[ 'autolow' ],
									[ 'low' ]
								],
								validate : function()
								{
									addChange( 'quality', this, PARAM | EMBED );
									return true;
								}
							},
						]
					},
					{
						type : 'hbox',
						widths : [ '50%', '50%' ],
						children :
						[
							{
								id : 'cmbAlign',
								type : 'select',
								label : editor.lang.flash.align,
								'default' : editor.config.pluginConfig.flash.defaultValues.align,
								style : 'width : 100%;',
								items :
								[
									[ editor.lang.common.notSet , ''],
									[ editor.lang.image.alignLeft , 'left'],
									[ editor.lang.image.alignAbsBottom , 'absBottom'],
									[ editor.lang.image.alignAbsMiddle , 'absMiddle'],
									[ editor.lang.image.alignBaseline , 'baseline'],
									[ editor.lang.image.alignBottom , 'bottom'],
									[ editor.lang.image.alignMiddle , 'middle'],
									[ editor.lang.image.alignRight , 'right'],
									[ editor.lang.image.alignTextTop , 'textTop'],
									[ editor.lang.image.alignTop , 'top']
								],
								validate : function()
								{
									addChange( 'align', this, OBJECT | EMBED );
									return true;
								}
							},
							{
								type : 'html',
								html : '<div></div>',
							}
						]
					},
					{
						type : 'text',
						id : 'txtFlashvars',
						label : editor.lang.flash.flashvars,
						checked : editor.config.pluginConfig.flash.defaultValues.flashvars,
						validate : function()
						{
							addChange( 'flashvars', this, PARAM | EMBED );
							return true;
						}
					},
					{
						type : 'checkbox',
						id : 'chkMenu',
						label : editor.lang.flash.chkMenu,
						checked : editor.config.pluginConfig.flash.defaultValues.menu,
						validate : function()
						{
							addChange( 'menu', this, PARAM | EMBED );
							return true;
						}
					},
					{
						type : 'checkbox',
						id : 'chkPlay',
						label : editor.lang.flash.chkPlay,
						checked : editor.config.pluginConfig.flash.defaultValues.play,
						validate : function()
						{
							addChange( 'play', this, PARAM | EMBED );
							return true;
						}
					},
					{
						type : 'checkbox',
						id : 'chkLoop',
						label : editor.lang.flash.chkLoop,
						checked : editor.config.pluginConfig.flash.defaultValues.loop,
						validate : function()
						{
							addChange( 'loop', this, PARAM | EMBED );
							return true;
						}
					},
					{
						type : 'checkbox',
						id : 'txtChkFull',
						label : editor.lang.flash.chkFull,
						checked : editor.config.pluginConfig.flash.defaultValues.allowfullscreen,
						validate : function()
						{
							addChange( 'allowfullscreen', this, PARAM | EMBED );
							return true;
						}
					}
				]
			},
			{
				id : 'advanced',
				label : editor.lang.common.advancedTab,
				elements :
				[
					{
						type : 'hbox',
						widths : [ '45%', '55%' ],
						children :
						[
							{
								type : 'text',
								id : 'txtGenId',
								label : editor.lang.common.id,
								validate : function()
								{
									addChange( 'id', this, OBJECT | EMBED );
									return true;
								}
							},
							{
								type : 'text',
								id : 'txtGenTitle',
								label : editor.lang.common.advisoryTitle,
								'default' : editor.config.pluginConfig.flash.defaultValues.title,
								validate : function()
								{
									addChange( 'title', this, OBJECT | EMBED );
									return true;
								}
							}
						]
					},
					{
						type : 'hbox',
						widths : [ '45%', '55%' ],
						children :
						[
							{
								type : 'text',
								id : 'txtBgcolor',
								label : editor.lang.flash.bgcolor,
								'default' : editor.config.pluginConfig.flash.defaultValues.bgcolor,
								validate : function()
								{
									addChange( 'bgcolor', this, PARAM | EMBED );
									return true;
								}
							},
							{
								type : 'text',
								id : 'txtGenClass',
								label : editor.lang.common.cssClass,
								'default' : editor.config.pluginConfig.flash.defaultValues.cssClass,
								validate : function()
								{
									addChange( 'class', this, OBJECT | EMBED );
									return true;
								}
							}
						]
					},
					{
						type : 'text',
						id : 'txtGenStyle',
						label : editor.lang.common.cssStyle,
						'default' : editor.config.pluginConfig.flash.defaultValues.cssStyle,
						validate : function()
						{
							addChange( 'style', this, OBJECT | EMBED );
							return true;
						}
					}
				]
			}
		]
	};
};

});
