/*
Copyright (c) 2003-2009, CKSource - Frederico Knabben. All rights reserved.
For licensing, see LICENSE.html or http://ckeditor.com/license
*/
CKEDITOR.dialog.add( 'checkbox', function( editor )
{
	var addChange = function( name, input ){
		var dialog = input.getDialog();
		if ( input.isChanged() || ( dialog.editMode == false && input.getValue() != '' ))
		{
			dialog.changedAttibutes[ name ] = input.getValue();
			return true;
		}
		return false;
	};

	// Function called in onShow to load selected element.
	var loadSelection = function( editor, selection, ranges, element )
	{
		this.saveSelection();
		this.editObj = element;
		this.editMode = true;

		// Fill out all fields.
		readAttribute.apply( this, [ this.editObj, 'info', 'name', 'txtName', true ] );
		readAttribute.apply( this, [ this.editObj, 'info', 'value', 'txtValue', true ] );
		readAttribute.apply( this, [ this.editObj, 'info', 'checked', 'cmbSelected', true ] );

		return false;
	};

	var readAttribute = function( object, page, attribute, input, setIfNull )
	{
		var attributeValue = object.getAttribute( attribute );
		if ( attributeValue == null )
			if ( setIfNull )
				this.setValueOf( page, input, "" );
		else
			this.setValueOf( page, input, attributeValue );
		return attributeValue;
	}

	return {
		title : editor.lang.checkboxAndRadio.checkboxTitle,
		resizable : CKEDITOR.DIALOG_RESIZE_NONE,
		minWidth : 400,
		minHeight : 230,
		onShow : function()
		{
			// Default: create a new element.
			this.editMode = false;
			this.changedAttibutes = new Array();

			// IE BUG: Selection must be in the editor for getSelection() to work.
			this.restoreSelection();

			var editor = this.getParentEditor(),
				selection = editor.getSelection(),
				ranges = selection.getRanges();

			// Check selection. Fill in all the relevant fields if there's already one link selected.
			if ( ranges.length == 1 )
			{
				ranges[0].enlarge( CKEDITOR.ENLARGE_ELEMENT );

				var rangeRoot = ranges[0].getCommonAncestor( true );
				var element = rangeRoot.getAscendant( 'input', true );
				if ( element && element.getAttribute( 'type' ) == "checkbox" )
				{
					loadSelection.apply( this, [ editor, selection, ranges, element ] );
					selection.selectElement( element );
				}
			}

			if ( this.editMode == false )	//New object.
				this.editObj = editor.document.createElement( 'input' );

			this.getContentElement( 'info', 'txtName' ).focus();
		},
		onOk : function()
		{
			this.changedAttibutes[ 'type' ] = 'checkbox';

			this.editObj.setAttributes( this.changedAttibutes );

			if ( this.editMode == false )
			{
				this.restoreSelection();
				this.clearSavedSelection();
				editor.insertElement( this.editObj );
			}
			return true;
		},
		contents : [
			{
				id : 'info',
				label : editor.lang.checkboxAndRadio.checkboxTitle,
				title : editor.lang.checkboxAndRadio.checkboxTitle,
				accessKey : 'I',
				elements : [
					{
						id : 'txtName',
						type : 'text',
						label : editor.lang.common.name,
						'default' : '',
						accessKey : 'N',
						validate: function()
						{
							addChange( 'name', this );
							return true;
						}
					},
					{
						id : 'txtValue',
						type : 'text',
						label : editor.lang.checkboxAndRadio.value,
						'default' : '',
						accessKey : 'V',
						validate: function()
						{
							addChange( 'value', this );
							return true;
						}
					},
					{
						id : 'cmbSelected',
						type : 'checkbox',
						label : editor.lang.checkboxAndRadio.selected,
						'default' : '',
						accessKey : 'S',
						value : "checked",
						validate: function()
						{
							addChange( 'checked', this );
							return true;
						}
					}
				]
			}
		]
	};
});
