/*
Copyright (c) 2003-2009, CKSource - Frederico Knabben. All rights reserved.
For licensing, see LICENSE.html or http://ckeditor.com/license
*/
CKEDITOR.dialog.add( 'form', function( editor )
{
	var addChange = function( name, input ){
		var dialog = input.getDialog();
		if ( input.isChanged() || ( dialog.editMode == false && input.getValue() != '' ))
		{
			dialog.changedAttibutes[ name ] = input.getValue();
			return true;
		}
		return false;
	};

	// Function called in onShow to load selected element.
	var loadSelection = function( editor, selection, ranges, element )
	{
		this.saveSelection();
		this.editObj = element;
		this.editMode = true;

		// Fill out all fields.
		readAttribute.apply( this, [ this.editObj, 'info', 'name', 'txtName', true ] );
		readAttribute.apply( this, [ this.editObj, 'info', 'action', 'txtAction', true ] );
		readAttribute.apply( this, [ this.editObj, 'info', 'method', 'cmbMethod', true ] );
		readAttribute.apply( this, [ this.editObj, 'info', 'encoding', 'cmbEncoding', true ] );
		readAttribute.apply( this, [ this.editObj, 'info', 'target', 'cmbTarget', true ] );
		readAttribute.apply( this, [ this.editObj, 'info', 'id', 'txtId', true ] );

		return false;
	};

	var readAttribute = function( object, page, attribute, input, setIfNull )
	{
		var attributeValue = object.getAttribute( attribute );
		if ( attributeValue == null )
			if ( setIfNull )
				this.setValueOf( page, input, "" );
		else
			this.setValueOf( page, input, attributeValue );
		return attributeValue;
	}

	return {
		title : editor.lang.form.title,
		resizable : CKEDITOR.DIALOG_RESIZE_NONE,
		minWidth : 400,
		minHeight : 270,
		onOk : function()
		{
			this.editObj.setAttributes( this.changedAttibutes );

			if ( this.editMode == false )
			{
				this.restoreSelection();
				this.clearSavedSelection();
				editor.insertElement( this.editObj );
			}
			return true;
		},
		onShow : function()
		{
			// Default: create a new element.
			this.editMode = false;
			this.changedAttibutes = new Array();

			// IE BUG: Selection must be in the editor for getSelection() to work.
			this.restoreSelection();

			var editor = this.getParentEditor(),
				selection = editor.getSelection(),
				ranges = selection.getRanges();

			// Check selection. Fill in all the relevant fields if there's already one link selected.
			if ( ranges.length == 1 )
			{
				ranges[0].enlarge( CKEDITOR.ENLARGE_ELEMENT );

				var rangeRoot = ranges[0].getCommonAncestor( true );
				var element = rangeRoot.getAscendant( 'form', true );
				if ( element )
				{
					loadSelection.apply( this, [ editor, selection, ranges, element ] );
					selection.selectElement( element );
				}
			}

			if( this.editMode == false )
				this.editObj = editor.document.createElement( 'form' );

			this.getContentElement( 'info', 'txtName' ).focus();
		},
		contents : [
			{
				id : 'info',
				label : editor.lang.form.title,
				title : editor.lang.form.title,
				accessKey : 'I',
				elements : [
					{
						id : 'txtName',
						type : 'text',
						label : editor.lang.common.name,
						'default' : '',
						accessKey : 'N',
						validate: function()
						{
							addChange( 'name', this );
							return true;
						}
					},
					{
						id : 'txtAction',
						type : 'text',
						label : editor.lang.form.action,
						'default' : editor.config.pluginConfig.forms.defaultValues.formAction,
						accessKey : 'A',
						validate: function()
						{
							addChange( 'action', this );
							return true;
						}
					},
					{
						type : 'hbox',
						widths : [ '45%', '55%' ],
						children :
						[
							{
								id : 'txtId',
								type : 'text',
								label : editor.lang.common.id,
								'default' : '',
								accessKey : 'I',
								validate: function()
								{
									addChange( 'id', this );
									return true;
								}
							},
							{
								id : 'cmbEncoding',
								type : 'select',
								label : editor.lang.form.encoding,
								style : 'width:100%',
								accessKey : 'E',
								'default' : editor.config.pluginConfig.forms.defaultValues.formEncoding,
								items :
								[
									[ 'text/plain' ],
									[ 'multipart/form-data' ],
									[ 'application/x-www-form-urlencoded' ]
								],
								validate: function()
								{
									addChange( 'encoding', this );
									return true;
								}
							}
						]
					},
					{
						type : 'hbox',
						widths : [ '45%', '55%' ],
						children :
						[
							{
								id : 'cmbTarget',
								type : 'select',
								label : editor.lang.form.target,
								style : 'width:100%',
								accessKey : 'M',
								'default' : editor.config.pluginConfig.forms.defaultValues.formTarget,
								items :
								[
									[ editor.lang.form.targetNotSet, '' ],
									[ editor.lang.form.targetNew, '_blank' ],
									[ editor.lang.form.targetTop, '_top' ],
									[ editor.lang.form.targetSelf, '_self' ],
									[ editor.lang.form.targetParent, '_parent' ]
								],
								validate: function()
								{
									addChange( 'target', this );
									return true;
								}
							},
							{
								id : 'cmbMethod',
								type : 'select',
								label : editor.lang.form.method,
								accessKey : 'M',
								'default' : editor.config.pluginConfig.forms.defaultValues.formMethod,
								items :
								[
									[ 'GET', 'get' ],
									[ 'POST', 'post' ]
								],
								validate: function()
								{
									addChange( 'method', this );
									return true;
								}
							}
						]
					}
				]
			}
		]
	};
});
