/*
Copyright (c) 2003-2009, CKSource - Frederico Knabben. All rights reserved.
For licensing, see LICENSE.html or http://ckeditor.com/license
*/

CKEDITOR.dialog.add( 'anchor', function( editor )
{
	// Function called in onShow to load selected element.
	var loadElements = function( editor, selection, ranges, element )
	{
		this.saveSelection();
		this.editMode = true;
		this.editObj = element;

		var attributeValue = this.editObj.getAttribute( 'name' );
		if ( attributeValue == null )
			this.setValueOf( 'info','txtName', "" );
		else
			this.setValueOf( 'info','txtName', attributeValue );
	};

	return {
		title : editor.lang.anchor.title,
		minWidth : 350,
		minHeight : 150,
		onOk : function()
		{
			// Create a new anchor.
			if ( !this.editMode )
				this.editObj = editor.document.createElement( 'a' );

			// Set name.
			var name = this.getContentElement( 'info', 'txtName' ).getValue();
			this.editObj.setAttribute( 'name', name );

			// Insert a new anchor.
			if ( !this.editMode )
			{
				// It doesn't work with IE.
				this.restoreSelection();
				this.clearSavedSelection();

				var fakeElement = editor.fakeobjects.protectElement( this.editObj );
				editor.insertElement( fakeElement );
			}
			else
				editor.fakeobjects.updateFakeElement( this.fakeObj, this.editObj );
			return true;
		},
		onShow : function()
		{
			this.editObj = false;
			this.fakeObj = false;
			this.editMode = false;

			// IE BUG: Selection must be in the editor for getSelection() to work.
			this.restoreSelection();

			var editor = this.getParentEditor(),
				selection = editor.getSelection(),
				ranges = selection.getRanges();

			if ( ranges.length == 1 )
			{
				ranges[0].enlarge( CKEDITOR.ENLARGE_ELEMENT );
				rangeRoot = ranges[0].getCommonAncestor( true );
				var element = rangeRoot.getAscendant( 'img', true );
				if ( element && element.getAttribute( '_cke_real_element_type' ) && element.getAttribute( '_cke_real_element_type' ) == 'anchor' )
				{
					this.fakeObj = element;
					element = editor.fakeobjects.restoreElement( this.fakeObj );
					loadElements.apply( this, [ editor, selection, ranges, element ] );
					selection.selectElement( this.fakeObj );
					this.saveSelection();
				}
			}
			this.pushDefault();
			this.getContentElement( 'info', 'txtName' ).focus();
		},
		onHide : function()
		{
			// Pop the default values from default value set that are pushed in onShow().
			this.popDefault();
		},
		contents : [
			{
				id : 'info',
				label : editor.lang.anchor.title,
				accessKey : 'I',
				elements :
				[
					{
						type : 'text',
						id : 'txtName',
						label : editor.lang.anchor.name,
						validate : function()
						{
							if ( this.getValue() == '' )
							{
								alert( editor.lang.anchor.errorName );
								return false;
							}
							return true;
						}
					},
				]
			}
		]
	};
} );
