/*
Copyright (c) 2003-2009, CKSource - Frederico Knabben. All rights reserved.
For licensing, see LICENSE.html or http://ckeditor.com/license
*/

/**
 * @file Horizontal Page Break
 */

// Register a plugin named "pagebreak".
CKEDITOR.plugins.add( 'pagebreak',
{
	init : function( editor, pluginPath )
	{
		editor.addCommand( 'pagebreak', CKEDITOR.plugins.pagebreak );
		editor.ui.addButton( 'PageBreak',
			{
				label : editor.lang.pagebreak,
				command : 'pagebreak'
			});
	},
	requires : [ 'fakeobjects' ]
});

CKEDITOR.plugins.pagebreak =
{
	pageBreakObject : function( editor, getProtected )
	{
		var breakObject = CKEDITOR.dom.element.createFromHtml( '<div style="page-break-after: always;"><span style="display: none;">&nbsp;</span></div>' );

		if ( getProtected )
			return editor.fakeobjects.protectElement( breakObject );
		else
			return breakObject;
	},
	removeOldBreaks : function( editor, limit )
	{
		// get all elements in CK document
		var elements = editor.document.$.getElementsByTagName( 'img' );
		// check every element for childNodes
		var count = 1;
		for( var i = 0; i < elements.length; i++ )
		{
			element = elements.item( i );
			if ( element.getAttribute( '_cke_protected_html' ) && element.getAttribute( '_cke_real_element_type' ) == "pagebreak" )
				if ( ++count >= limit )
					element.parentNode.removeChild( element );
		}
	},
	exec : function( editor )
	{
		var element = CKEDITOR.plugins.pagebreak.pageBreakObject( editor, true );
		if ( editor.config.pluginConfig.pagebreak.pageBreakeLimit !== false)
			CKEDITOR.plugins.pagebreak.removeOldBreaks( editor, editor.config.pluginConfig.pagebreak.pageBreakeLimit -1 );
		editor.insertElement( element );
	}
};
