/*
Copyright (c) 2003-2009, CKSource - Frederico Knabben. All rights reserved.
For licensing, see LICENSE.html or http://ckeditor.com/license
*/

/**
 * @file Print CKE Document
 */

// Register a plugin named "print".
CKEDITOR.plugins.add( 'print',
{
	init : function( editor, pluginPath )
	{
		editor.addCommand( 'print', CKEDITOR.plugins.print );
		editor.ui.addButton( 'Print',
			{
				label : editor.lang.print,
				command : 'print'
			});
	}
});

CKEDITOR.plugins.print =
{
	// Print CKE document.
	printCKEDocument : function( editor ){
		editor.window.$.print();
	},

	// Print the whole page.
	printPage : function( editor ){
		window.print();
	},

	exec : function( editor )
	{
		if (editor.config.print == 'page' )
			CKEDITOR.plugins.print.printPage( editor );
		else
			CKEDITOR.plugins.print.printCKEDocument( editor );
	}
};
