/*
Copyright (c) 2003-2009, CKSource - Frederico Knabben. All rights reserved.
For licensing, see LICENSE.html or http://ckeditor.com/license
*/

(function()
{
	var preProcess = function ( scope, node, names )
	{
		var child = node.getFirstChild();
		while( child )
		{
			switch ( child.getType() )
			{
				case Token.THIS :
					scope.thisCount++;
					break;

				case Token.FUNCTION :

					// Functions are considered declared since the very start
					// of the scope execution. So, we must look for them here.
					// Unfortunately Symbol.declType is not public in the Rhino
					// code.

					scope.functionCount++;

					var name = String( child.getString() );
					if ( name.length > 0 )
						scope.declaredNames[ name ] = 1;
					break;

				default:
					preProcess( scope, child, names );
			}

			child = child.getNext();
		}

		return names;
	};

	CKPACKAGER.scope = function( rhinoNode, parentScope )
	{
		this.node = rhinoNode;
		this.parent = parentScope;
		this.args = [];
		this.names = {};
		this.declaredNames =
		{
			'this' : 1
		};
		this.thisCount = 0;
		this.functionCount = 0;
		this.noRename = false;

		this.newNames = {};
		this.nameCounter = parentScope ? parentScope.nameCounter : 0;

		if ( rhinoNode.symbolTable != null )
		{
			var iter = rhinoNode.symbolTable.keySet().iterator(),
				paramCount = rhinoNode.getParamCount();

			while ( iter.hasNext() )
			{
				var symbol = String( iter.next() );

				if ( this.args.length < paramCount )
				{
					this.args.push( symbol );
					this.declaredNames[ symbol ] = 1;
				}

				this.names[ symbol ] = getNextName( this );
			}
		}

		preProcess( this, rhinoNode );
	}

	var nameChars = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789'.split( '' ),
		nameCharsLength = nameChars.length;

	// Mangles the list, having a different order for each run.
	/*
	nameChars.sort( function( a, b )
		{
			return Math.random() < 0.5 ? -1 : 1;
		});
	*/

	var getNextName = function( scope )
	{
		var name;

		do
		{
			var number = ++scope.nameCounter;

			name = '';

			while ( true )
			{
				var mod = number % nameCharsLength;
				number = Math.floor( number / nameCharsLength );

				if ( mod == 0 )
				{
					name = nameChars[ nameCharsLength - 1 ] + name;
					number--;
				}
				else
				{
					name = nameChars[ mod - 1 ] + name;
				}

				if ( number <= 0 )
					break;
			}
		}
		while ( !isNaN( name.substr( 0, 1 ) ) )

		return name;
	};

	CKPACKAGER.scope.prototype.getNewName = function( name, includeNotDeclared, includeNotListed )
	{
		if ( !this.noRename )
		{
			if ( ( includeNotDeclared || this.declaredNames[ name ] ) && this.names[ name ] )
				return this.names[ name ];
			else if ( includeNotListed || name == 'this' )
				return ( this.declaredNames[ name ] = this.names[ name ] = getNextName( this ) );
			else if ( this.parent )
				return this.parent.getNewName( name, true );
		}

		return name;
	};

	CKPACKAGER.scope.prototype.declareName = function( name )
	{
		this.declaredNames[ name ] = 1;
	};

	CKPACKAGER.scope.prototype.addRenamedRef = function( name )
	{
		return this.names[ name ] = getNextName( this );
	};
})();
