/*
 * Decompiled with CFR 0.152.
 */
package net.fckeditor.devutil.dtd;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementGroup<T>
extends HashSet<T> {
    protected Set<ElementGroup<T>> _subGroups = new HashSet<ElementGroup<T>>();

    public ElementGroup<T> intersectGroup(ElementGroup<T> group) {
        ElementGroup smallGroup = group.size() < this.size() ? group : this;
        ElementGroup largeGroup = group.size() >= this.size() ? group : this;
        ElementGroup<T> intersection = new ElementGroup<T>();
        for (Object currElement : smallGroup) {
            if (!largeGroup.contains(currElement)) continue;
            intersection.add(currElement);
        }
        return intersection;
    }

    public void addSubGroup(ElementGroup<T> group) {
        this.removeAll(group);
        this._subGroups.add(group);
    }

    public Set<ElementGroup<T>> getSubGroups() {
        return this._subGroups;
    }

    public int getTotalSize() {
        int start = this.size();
        if (this._subGroups.size() == 0) {
            return start;
        }
        Iterator<ElementGroup<T>> it = this._subGroups.iterator();
        while (it.hasNext()) {
            start += it.next().getTotalSize();
        }
        return start;
    }

    @Override
    public String toString() {
        return this.recursiveToString("");
    }

    private String recursiveToString(String indent) {
        String result = String.valueOf(indent) + super.toString() + " (" + System.identityHashCode(this) + ")\n";
        Iterator<ElementGroup<T>> it = this._subGroups.iterator();
        while (it.hasNext()) {
            result = String.valueOf(result) + indent + super.recursiveToString(String.valueOf(indent) + "  ");
        }
        return result;
    }

    public boolean equals(ElementGroup cmpGroup) {
        if (this == cmpGroup) {
            return true;
        }
        if (!super.equals(cmpGroup)) {
            return false;
        }
        return this._subGroups.equals(cmpGroup._subGroups);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        Iterator<Object> it = this.iterator();
        while (it.hasNext()) {
            hashCode ^= it.next().hashCode();
        }
        it = this._subGroups.iterator();
        while (it.hasNext()) {
            hashCode ^= ((ElementGroup)it.next()).hashCode();
        }
        return hashCode;
    }
}

