/*
 * Decompiled with CFR 0.152.
 */
package net.fckeditor.devutil.dtd;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.fckeditor.devutil.dtd.ElementGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementGroupMapJavascriptBuilder {
    private static final String DTDMAP_NAME = "FCK.DTD";
    private static final String MERGE_FUNCTION = "X";
    private static final String MERGE_FUNCTION_DEF = "X = FCKTools.Merge ;";
    private static final String REFERENCE_ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWYZ";
    private int _varCount;
    private Map<ElementGroup, String> _subGroupAliasMap;

    public String buildJavaScript(String sourceDesc, Map<String, ElementGroup> groupMap) {
        this._varCount = 0;
        this._subGroupAliasMap = new HashMap<ElementGroup, String>();
        StringBuilder str = new StringBuilder();
        this.appendHeader(str, sourceDesc);
        this.appendElementMapFunctionCode(str, groupMap);
        return str.toString();
    }

    protected void appendHeader(StringBuilder str, String sourceDesc) {
        str.append("/*\n");
        str.append(" * FCKeditor - The text editor for Internet - http://www.fckeditor.net\n");
        str.append(" * Copyright (C) 2003-2007 Frederico Caldeira Knabben\n");
        str.append(" *\n");
        str.append(" * == BEGIN LICENSE ==\n");
        str.append(" *\n");
        str.append(" * Licensed under the terms of any of the following licenses at your\n");
        str.append(" * choice:\n");
        str.append(" *\n");
        str.append(" *  - GNU General Public License Version 2 or later (the \"GPL\")\n");
        str.append(" *    http://www.gnu.org/licenses/gpl.html\n");
        str.append(" *\n");
        str.append(" *  - GNU Lesser General Public License Version 2.1 or later (the \"LGPL\")\n");
        str.append(" *    http://www.gnu.org/licenses/lgpl.html\n");
        str.append(" *\n");
        str.append(" *  - Mozilla Public License Version 1.1 or later (the \"MPL\")\n");
        str.append(" *    http://www.mozilla.org/MPL/MPL-1.1.html\n");
        str.append(" *\n");
        str.append(" * == END LICENSE ==\n");
        str.append(" *\n");
        str.append(" * Contains the DTD mapping for <DTD_NAME>.\n");
        str.append(" * ").append(sourceDesc);
        str.append("\n */\n");
    }

    protected void appendElementMapFunctionCode(StringBuilder outStr, Map<String, ElementGroup> groupMap) {
        ElementGroup currGroup;
        StringBuilder str = new StringBuilder();
        HashMap<ElementGroup, Integer> baseGroupCountMap = new HashMap<ElementGroup, Integer>();
        for (String elementName : groupMap.keySet()) {
            currGroup = groupMap.get(elementName);
            this.appendMissingSubGroupsRecursive(str, currGroup);
            if (!baseGroupCountMap.containsKey(currGroup)) {
                baseGroupCountMap.put(currGroup, 1);
                continue;
            }
            baseGroupCountMap.put(currGroup, (Integer)baseGroupCountMap.get(currGroup) + 1);
        }
        str.append("\n");
        for (ElementGroup group : baseGroupCountMap.keySet()) {
            int directUseSize;
            int occurrenceCount;
            int referenceSize;
            int contentSize = group.getSubGroups().size() * 2 + 4;
            if (group.size() > 0) {
                for (String elementName : group) {
                    contentSize += elementName.length() + 3;
                }
                contentSize += 2;
            }
            if (contentSize == 4 || (referenceSize = (occurrenceCount = ((Integer)baseGroupCountMap.get(group)).intValue()) * 2 + contentSize + 2) >= (directUseSize = occurrenceCount * contentSize)) continue;
            this.appendGroupReference(str, group);
        }
        str.append("\n");
        str.append("    return {\n");
        Iterator<String> it = groupMap.keySet().iterator();
        while (it.hasNext()) {
            String elementName;
            elementName = it.next();
            currGroup = groupMap.get(elementName);
            str.append("        ");
            this.appendEscapedJsMapKey(str, elementName);
            str.append(": ");
            this.appendGroupMapContent(str, currGroup);
            if (it.hasNext()) {
                str.append(", ");
            }
            str.append("\n");
        }
        str.append("    } ;\n");
        outStr.append(DTDMAP_NAME).append(" = (function()\n{\n    ");
        outStr.append(MERGE_FUNCTION_DEF).append("\n\n    var ");
        it = this._subGroupAliasMap.values().iterator();
        while (it.hasNext()) {
            String varname = it.next();
            outStr.append(varname);
            if (!it.hasNext()) continue;
            outStr.append(',');
        }
        outStr.append("; \n");
        outStr.append((CharSequence)str).append("})() ;");
    }

    protected void appendMissingSubGroupsRecursive(StringBuilder str, ElementGroup currGroup) {
        Set subGroups = currGroup.getSubGroups();
        if (subGroups.size() == 0 && currGroup.size() == 0) {
            return;
        }
        if (subGroups.size() > 0) {
            for (ElementGroup currSubGroup : subGroups) {
                if (this._subGroupAliasMap.containsKey(currSubGroup)) continue;
                this.appendMissingSubGroupsRecursive(str, currSubGroup);
                this.appendGroupReference(str, currSubGroup);
            }
        }
    }

    protected void appendGroupReference(StringBuilder str, ElementGroup group) {
        String groupAlias = this.createNextGroupAlias();
        str.append("    ").append(groupAlias).append(" = ");
        this.appendGroupMapContent(str, group);
        str.append(" ;\n");
        this._subGroupAliasMap.put(group, groupAlias);
    }

    protected String createNextGroupAlias() {
        int baseLen = REFERENCE_ALPHABET.length();
        StringBuilder str = new StringBuilder();
        int currNum = this._varCount + baseLen;
        do {
            str.append(REFERENCE_ALPHABET.charAt(currNum % baseLen));
        } while ((currNum /= baseLen) > 1);
        ++this._varCount;
        return str.reverse().toString();
    }

    protected void appendGroupMapContent(StringBuilder str, ElementGroup currGroup) {
        Iterator<Object> it;
        if (this._subGroupAliasMap.containsKey(currGroup)) {
            str.append(this._subGroupAliasMap.get(currGroup));
            return;
        }
        Set subGroups = currGroup.getSubGroups();
        if ((currGroup.size() > 0 ? 1 : 0) + subGroups.size() > 1) {
            str.append("X(");
        }
        if (currGroup.size() > 0 || subGroups.size() == 0) {
            str.append("{");
            it = currGroup.iterator();
            while (it.hasNext()) {
                String innerElementName = (String)it.next();
                this.appendEscapedJsMapKey(str, innerElementName);
                str.append(":1");
                if (!it.hasNext()) continue;
                str.append(", ");
            }
            str.append("}");
        }
        if (subGroups.size() == 0) {
            return;
        }
        if (currGroup.size() > 0) {
            str.append(", ");
        }
        it = subGroups.iterator();
        while (it.hasNext()) {
            ElementGroup group = (ElementGroup)it.next();
            str.append(this._subGroupAliasMap.get(group));
            if (!it.hasNext()) continue;
            str.append(", ");
        }
        if (subGroups.size() + currGroup.size() > 1) {
            str.append(")");
        }
    }

    protected void appendEscapedJsMapKey(StringBuilder str, String key) {
        if ("#".equals(key) || "var".equals(key)) {
            str.append('\'').append(key).append('\'');
        } else {
            str.append(key);
        }
    }
}

