/*
 * Decompiled with CFR 0.152.
 */
package net.fckeditor.devutil.dtd;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import net.fckeditor.devutil.dtd.ElementGroup;
import net.fckeditor.devutil.dtd.ElementGroupMapJavascriptBuilder;
import net.fckeditor.devutil.dtd.ElementGroupSizeComparator;
import net.fckeditor.devutil.dtd.WutkaDTDParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DTDJsGenerator {
    private static final String APPLICATION_NAME = "FCKdtd2js";
    protected URI _dtdUri;
    protected Set _removeTags;

    public static void main(String[] args) {
        if (args.length < 1) {
            DTDJsGenerator.writeHelp(System.out);
        }
        URI dtdUri = null;
        File dtdFile = new File(args[0].trim());
        if (dtdFile.exists()) {
            dtdUri = dtdFile.getAbsoluteFile().toURI();
        } else {
            try {
                dtdUri = new URI(args[0].trim());
                if (!dtdUri.isAbsolute()) {
                    System.err.println("URI is not absolute : " + args[0].trim());
                    return;
                }
            }
            catch (URISyntaxException e) {
                System.err.println("Unable to parse : " + args[0].trim());
                return;
            }
        }
        HashSet<String> removeTags = new HashSet<String>();
        if (args.length > 1) {
            StringTokenizer st = new StringTokenizer(args[1], ",");
            while (st.hasMoreTokens()) {
                String removeTag = st.nextToken().trim();
                if (removeTag.length() <= 0) continue;
                removeTags.add(removeTag);
            }
        }
        try {
            DTDJsGenerator generator = new DTDJsGenerator(dtdUri, removeTags);
            generator.run();
        }
        catch (Exception e) {
            System.err.println(e.getLocalizedMessage());
            e.printStackTrace(System.err);
        }
    }

    protected static void writeHelp(PrintStream out) {
        out.println("FCKdtd2js: Simple utility to create a JavaScript from a given DTD.\n");
        out.println("Usage: java -jar FCKdtd2js.jar <dtdfile> <ignoretag,...>]");
        out.println("  dtdfile - The path/URL to the DTD file to parse.");
        out.println("  ignoretag - Comma separated list of tags to ignore in DTD");
        System.exit(0);
    }

    public DTDJsGenerator(URI dtdUri, Set removeTags) {
        if (dtdUri == null || removeTags == null) {
            throw new IllegalArgumentException("File parameter cannot be null.");
        }
        this._dtdUri = dtdUri;
        if (removeTags == null) {
            removeTags = Collections.EMPTY_SET;
        }
        this._removeTags = removeTags;
    }

    public void run() throws IOException, ParseException {
        WutkaDTDParser xmlDefParser = new WutkaDTDParser();
        Map<String, ElementGroup> groupMap = xmlDefParser.parseXmlDefinition(this._dtdUri);
        if (this._removeTags != null) {
            groupMap.keySet().removeAll(this._removeTags);
        }
        this.compressElementGroupMap(groupMap);
        this.flattenElementGroupMap(groupMap);
        String comment = "This file was automatically generated from : " + new File(this._dtdUri.getPath()).getName();
        ElementGroupMapJavascriptBuilder jsBuilder = new ElementGroupMapJavascriptBuilder();
        String javaScript = jsBuilder.buildJavaScript(comment, groupMap);
        System.out.println(javaScript);
    }

    protected void printGroupMap(Map<String, ElementGroup> groupMap) {
        for (String key : groupMap.keySet()) {
            ElementGroup group = groupMap.get(key);
            System.out.println("Element [" + key + "]:");
            System.out.println(String.valueOf(group.toString()) + "\n");
        }
    }

    protected void flattenElementGroupMap(Map<String, ElementGroup> groupMap) {
        Iterator<String> it = groupMap.keySet().iterator();
        while (it.hasNext()) {
            this.internalRecursiveFlattenElementGroupMap(groupMap.get(it.next()));
        }
    }

    private void internalRecursiveFlattenElementGroupMap(ElementGroup group) {
        LinkedList addList = new LinkedList();
        Iterator it = group.getSubGroups().iterator();
        while (it.hasNext()) {
            ElementGroup currSubGroup = it.next();
            this.internalRecursiveFlattenElementGroupMap(currSubGroup);
            if (currSubGroup.size() != 0) continue;
            addList.addAll(currSubGroup.getSubGroups());
            it.remove();
        }
        group.getSubGroups().addAll(addList);
    }

    protected void compressElementGroupMap(Map<String, ElementGroup> groupMap) {
        for (String key1 : groupMap.keySet()) {
            for (String key2 : groupMap.keySet()) {
                ElementGroup group2;
                ElementGroup group1 = groupMap.get(key1);
                if (group1 == (group2 = groupMap.get(key2)) || !group1.equals(group2)) continue;
                groupMap.put(key2, group1);
            }
        }
        TreeSet<ElementGroup> tree = new TreeSet<ElementGroup>(new ElementGroupSizeComparator());
        tree.addAll(groupMap.values());
        block2: while (tree.size() > 0) {
            Iterator<ElementGroup> it = tree.iterator();
            ElementGroup topGroup = it.next();
            if (topGroup.size() > 2) {
                while (it.hasNext()) {
                    ElementGroup candidate = it.next();
                    ElementGroup intersection = topGroup.intersectGroup(candidate);
                    if (intersection.size() < 2) continue;
                    it.remove();
                    tree.remove(tree.first());
                    topGroup.addSubGroup(intersection);
                    candidate.addSubGroup(intersection);
                    tree.add(topGroup);
                    tree.add(candidate);
                    tree.add(intersection);
                    continue block2;
                }
            }
            tree.remove(tree.first());
        }
    }
}

