/*
 * Decompiled with CFR 0.152.
 */
package net.fckeditor.devutil.dtd;

import com.wutka.dtd.DTD;
import com.wutka.dtd.DTDContainer;
import com.wutka.dtd.DTDElement;
import com.wutka.dtd.DTDEmpty;
import com.wutka.dtd.DTDItem;
import com.wutka.dtd.DTDName;
import com.wutka.dtd.DTDPCData;
import com.wutka.dtd.DTDParser;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.fckeditor.devutil.dtd.ElementGroup;
import net.fckeditor.devutil.dtd.XmlDefinitionParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WutkaDTDParser
implements XmlDefinitionParser {
    @Override
    public Map<String, ElementGroup> parseXmlDefinition(URI uri) throws IOException {
        DTDParser parser = new DTDParser(uri.toURL());
        DTD dtd = parser.parse();
        return this.createElementGroupMap(dtd);
    }

    protected Map<String, ElementGroup> createElementGroupMap(DTD dtd) {
        ElementGroup emptyGroup = new ElementGroup();
        HashMap<String, ElementGroup> resultMap = new HashMap<String, ElementGroup>();
        Collection elements = dtd.elements.values();
        for (DTDElement element : elements) {
            if (element.content instanceof DTDContainer) {
                ElementGroup<String> newGroup = new ElementGroup<String>();
                if (!this.appendAllowedElementsRecursive((DTDContainer)element.content, newGroup)) continue;
                resultMap.put(element.name, newGroup);
                continue;
            }
            if (!(element.content instanceof DTDEmpty)) continue;
            resultMap.put(element.name, emptyGroup);
        }
        return resultMap;
    }

    protected boolean appendAllowedElementsRecursive(DTDContainer col, ElementGroup<String> targetGroup) {
        DTDItem[] allowedChilds = col.getItems();
        boolean hasRealContent = false;
        int i = 0;
        while (i < allowedChilds.length) {
            if (allowedChilds[i] instanceof DTDName) {
                targetGroup.add(((DTDName)allowedChilds[i]).value);
                hasRealContent = true;
            } else if (allowedChilds[i] instanceof DTDContainer) {
                boolean recResult = this.appendAllowedElementsRecursive((DTDContainer)allowedChilds[i], targetGroup);
                hasRealContent = hasRealContent || recResult;
            } else if (allowedChilds[i] instanceof DTDPCData) {
                targetGroup.add("#");
                hasRealContent = true;
            } else if (allowedChilds[i] instanceof DTDEmpty) {
                hasRealContent = true;
            }
            ++i;
        }
        return hasRealContent;
    }
}

