package net.fckeditor.devutil.dtd;

import java.io.IOException;
import java.net.URI;
import java.util.Map;


/**
 * Interface implemented by all classes providing means for parsing a XML
 * definition file into a Map of ElementGroups. Examples of XML definition
 * files are DTDs and XML Schemas (XSD). 
 */
public interface XmlDefinitionParser {

	/**
	 * Method used parse a Xml definition into a Map of ElementGroups. 
	 * 
	 * @param url The URL for the definition
	 * @return Map of elementgroups representing the XML definition.
	 * @throws IOException if DTD could not be parsed.
	 */
	public Map<String, ElementGroup> parseXmlDefinition(URI url) throws IOException;
	
}
