package net.fckeditor;

import javax.servlet.http.HttpServletRequest;

import org.junit.Test;
import static org.mockito.Mockito.*;

public class FCKeditorTest {
	
	@Test(expected = NullPointerException.class)
	public void testNullRequest() {
		new FCKeditor(null, "name");
	}
	
	@Test(expected = IllegalArgumentException.class)
	public void testEmptyInstanceName() {
		HttpServletRequest request = mock(HttpServletRequest.class);
		
		new FCKeditor(request, null);
	}
	
	@Test(expected = IllegalArgumentException.class)
	public void testEmptyInstanceName02() {
		HttpServletRequest request = mock(HttpServletRequest.class);
		
		new FCKeditor(request, "");
	}
	
	@Test(expected = IllegalArgumentException.class)
	public void testIllegalInstanceName() {
		HttpServletRequest request = mock(HttpServletRequest.class);
		
		new FCKeditor(request, "my instance");
	}
	
	@Test(expected = IllegalArgumentException.class)
	public void testIllegalInstanceName02() {
		HttpServletRequest request = mock(HttpServletRequest.class);
		
		new FCKeditor(request, "01_instance");
	}
	
	@Test
	public void testValidInstanceName() {
		HttpServletRequest request = mock(HttpServletRequest.class);
		
		new FCKeditor(request, "myInstance");
	}

}